/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.access.firewall.FirewallRule;
import org.apache.qpid.server.security.access.firewall.InetNetwork;

public class NetworkFirewallRule
implements FirewallRule {
    private static final Logger _logger = Logger.getLogger(NetworkFirewallRule.class);
    private List<InetNetwork> _networks = new ArrayList<InetNetwork>();

    public NetworkFirewallRule(String ... networks) {
        for (int i = 0; i < networks.length; ++i) {
            String network = networks[i];
            try {
                InetNetwork inetNetwork = InetNetwork.getFromString(network);
                if (this._networks.contains(inetNetwork)) continue;
                this._networks.add(inetNetwork);
                continue;
            }
            catch (UnknownHostException uhe) {
                _logger.error((Object)("Cannot resolve address: " + network), (Throwable)uhe);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created " + this));
        }
    }

    public boolean matches(InetAddress ip) {
        for (InetNetwork network : this._networks) {
            if (!network.contains(ip)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Client address " + ip + " matches configured network " + network));
            }
            return true;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Client address " + ip + " does not match any configured networks"));
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this._networks).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NetworkFirewallRule rhs = (NetworkFirewallRule)obj;
        return new EqualsBuilder().append(this._networks, rhs._networks).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this._networks).toString();
    }
}

