/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.plugin.AccessControlFactory;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.access.plugins.DefaultAccessControl;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.util.ResourceBundleLoader;

public class DefaultAccessControlFactory
implements AccessControlFactory {
    public static final String RESOURCE_BUNDLE = "org.apache.qpid.server.security.access.plugins.FileAccessControlProviderAttributeDescriptions";
    public static final Collection<String> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("type", "path"));

    public AccessControl createInstance(Map<String, Object> attributes) {
        if (attributes == null || !"AclFile".equals(attributes.get("type"))) {
            return null;
        }
        String path = MapValueConverter.getStringAttribute((String)"path", attributes, null);
        if (path == null || "".equals(path.trim())) {
            throw new IllegalConfigurationException("Path to ACL was not specified!");
        }
        return new DefaultAccessControl(path);
    }

    public String getType() {
        return "AclFile";
    }

    public Collection<String> getAttributeNames() {
        return ATTRIBUTES;
    }

    public Map<String, String> getAttributeDescriptions() {
        return ResourceBundleLoader.getResources((String)RESOURCE_BUNDLE);
    }
}

