/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.io.File;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.access.config.ConfigurationFile;
import org.apache.qpid.server.security.access.config.RuleSet;

public abstract class AbstractConfiguration
implements ConfigurationFile {
    private File _file;
    private RuleSet _config;
    private final EventLoggerProvider _eventLogger;

    public AbstractConfiguration(File file, EventLoggerProvider eventLogger) {
        this._file = file;
        this._eventLogger = eventLogger;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public RuleSet load() {
        this._config = new RuleSet(this._eventLogger);
        return this._config;
    }

    @Override
    public RuleSet getConfiguration() {
        return this._config;
    }

    @Override
    public boolean save(RuleSet configuration) {
        return true;
    }

    @Override
    public RuleSet reload() {
        RuleSet oldRules = this._config;
        try {
            RuleSet newRules;
            this._config = newRules = this.load();
        }
        catch (Exception e) {
            this._config = oldRules;
        }
        return this._config;
    }
}

