/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.net.InetAddress;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.firewall.FirewallRule;

public class ClientAction {
    private Action _clientAction;

    public ClientAction(Action clientAction) {
        this._clientAction = clientAction;
    }

    public ClientAction(Operation operation, ObjectType objectType, ObjectProperties properties) {
        this._clientAction = new Action(operation, objectType, properties);
    }

    public boolean matches(AclAction ruleAction, InetAddress addressOfClient) {
        return this._clientAction.matches(ruleAction.getAction()) && this.addressOfClientMatches(ruleAction, addressOfClient);
    }

    private boolean addressOfClientMatches(AclAction ruleAction, InetAddress addressOfClient) {
        FirewallRule firewallRule = ruleAction.getFirewallRule();
        if (firewallRule == null || addressOfClient == null) {
            return true;
        }
        return firewallRule.matches(addressOfClient);
    }

    public Operation getOperation() {
        return this._clientAction.getOperation();
    }

    public ObjectType getObjectType() {
        return this._clientAction.getObjectType();
    }

    public ObjectProperties getProperties() {
        return this._clientAction.getProperties();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this._clientAction).toString();
    }
}

