/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.Action;

public class Rule
implements Comparable<Rule> {
    public static final String ALL = "all";
    private Integer _number;
    private Boolean _enabled = Boolean.TRUE;
    private String _identity;
    private AclAction _action;
    private Permission _permission;

    public Rule(Integer number, String identity, AclAction action, Permission permission) {
        this.setNumber(number);
        this.setIdentity(identity);
        this.setAction(action);
        this.setPermission(permission);
    }

    public Rule(String identity, AclAction action, Permission permission) {
        this(null, identity, action, permission);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void enable() {
        this._enabled = Boolean.TRUE;
    }

    public void disable() {
        this._enabled = Boolean.FALSE;
    }

    public Integer getNumber() {
        return this._number;
    }

    public void setNumber(Integer number) {
        this._number = number;
    }

    public String getIdentity() {
        return this._identity;
    }

    public void setIdentity(String identity) {
        this._identity = identity;
    }

    public Action getAction() {
        return this._action.getAction();
    }

    public AclAction getAclAction() {
        return this._action;
    }

    public void setAction(AclAction action) {
        this._action = action;
    }

    public Permission getPermission() {
        return this._permission;
    }

    public void setPermission(Permission permission) {
        this._permission = permission;
    }

    @Override
    public int compareTo(Rule r) {
        return new CompareToBuilder().append((Object)this.getAction(), (Object)r.getAction()).append((Object)this.getIdentity(), (Object)r.getIdentity()).append((Object)this.getPermission(), (Object)r.getPermission()).toComparison();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule r = (Rule)o;
        return new EqualsBuilder().append((Object)this.getIdentity(), (Object)r.getIdentity()).append((Object)this.getAclAction(), (Object)r.getAclAction()).append((Object)this.getPermission(), (Object)r.getPermission()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentity()).append((Object)this.getAclAction()).append((Object)this.getPermission()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("#", (Object)this.getNumber()).append("identity", (Object)this.getIdentity()).append("action", (Object)this.getAclAction()).append("permission", (Object)this.getPermission()).append("enabled", this.isEnabled()).toString();
    }
}

