/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.PlainConfiguration;
import org.apache.qpid.server.security.access.config.RuleSet;

public class DefaultAccessControl
implements AccessControl {
    private static final Logger _logger = Logger.getLogger(DefaultAccessControl.class);
    private RuleSet _ruleSet;
    private File _aclFile;
    private final EventLoggerProvider _eventLogger;

    public DefaultAccessControl(String fileName, EventLoggerProvider eventLogger) {
        this._eventLogger = eventLogger;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Creating AccessControl instance using file: " + fileName));
        }
        this._aclFile = new File(fileName);
    }

    DefaultAccessControl(RuleSet rs) throws ConfigurationException {
        this._ruleSet = rs;
        this._eventLogger = rs;
    }

    public void open() {
        if (this._aclFile != null) {
            if (!this._aclFile.exists()) {
                throw new IllegalConfigurationException("ACL file '" + this._aclFile + "' is not found");
            }
            PlainConfiguration configFile = new PlainConfiguration(this._aclFile, this._eventLogger);
            this._ruleSet = configFile.load();
        }
    }

    public void close() {
    }

    public void onDelete() {
    }

    public void onCreate() {
        if (this._aclFile != null) {
            if (!this._aclFile.exists()) {
                throw new IllegalConfigurationException("ACL file '" + this._aclFile + "' is not found");
            }
            new PlainConfiguration(this._aclFile, this._eventLogger).load();
        }
    }

    public Result getDefault() {
        return this._ruleSet.getDefault();
    }

    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        SocketAddress address;
        InetAddress addressOfClient = null;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.getPrincipals().size() == 0) {
            return Result.ABSTAIN;
        }
        Set<ConnectionPrincipal> principals = subject.getPrincipals(ConnectionPrincipal.class);
        if (!principals.isEmpty() && (address = principals.iterator().next().getConnection().getRemoteAddress()) instanceof InetSocketAddress) {
            addressOfClient = ((InetSocketAddress)address).getAddress();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Checking " + operation + " " + objectType + " " + ObjectUtils.defaultIfNull((Object)addressOfClient, (Object)"")));
        }
        try {
            return this._ruleSet.check(subject, operation, objectType, properties, addressOfClient);
        }
        catch (Exception e) {
            _logger.error((Object)("Unable to check " + operation + " " + objectType + " " + ObjectUtils.defaultIfNull((Object)addressOfClient, (Object)"")), (Throwable)e);
            return Result.DENIED;
        }
    }
}

