/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.plugins.ACLFileAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.DefaultAccessControl;

public class ACLFileAccessControlProviderImpl
extends AbstractConfiguredObject<ACLFileAccessControlProviderImpl>
implements ACLFileAccessControlProvider<ACLFileAccessControlProviderImpl> {
    private static final Logger LOGGER = Logger.getLogger(ACLFileAccessControlProviderImpl.class);
    protected DefaultAccessControl _accessControl;
    protected final Broker _broker;
    private AtomicReference<State> _state = new AtomicReference<State>(State.UNINITIALIZED);
    @ManagedAttributeField
    private String _path;

    @ManagedObjectFactoryConstructor
    public ACLFileAccessControlProviderImpl(Map<String, Object> attributes, Broker broker) {
        super(ACLFileAccessControlProviderImpl.parentsMap((ConfiguredObject[])new ConfiguredObject[]{broker}), attributes);
        this._broker = broker;
    }

    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("durable") && !proxyForValidation.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    protected void onOpen() {
        super.onOpen();
        this._accessControl = new DefaultAccessControl(this.getPath(), (EventLoggerProvider)this._broker);
    }

    @Override
    public String getPath() {
        return this._path;
    }

    public State getState() {
        return this._state.get();
    }

    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private void activate() {
        if (this._broker.isManagementMode()) {
            this._state.set(this._accessControl.validate() ? State.QUIESCED : State.ERRORED);
        } else {
            try {
                this._accessControl.open();
                this._state.set(State.ACTIVE);
            }
            catch (RuntimeException e) {
                this._state.set(State.ERRORED);
                if (this._broker.isManagementMode()) {
                    LOGGER.warn((Object)("Failed to activate ACL provider: " + this.getName()), (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void onClose() {
        super.onClose();
        this._accessControl.close();
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private void startQuiesced() {
        this._state.set(State.QUIESCED);
    }

    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED}, desiredState=State.DELETED)
    private void doDelete() {
        this.close();
        this._state.set(State.DELETED);
        this.deleted();
    }

    protected void authoriseSetDesiredState(State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AccessControlProvider.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of AccessControlProvider is denied");
        }
    }

    protected void authoriseSetAttributes(ConfiguredObject<?> modified, Set<String> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), AccessControlProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of AccessControlProvider attributes is denied");
        }
    }

    public AccessControl getAccessControl() {
        return this._accessControl;
    }
}

