/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.firewall.FirewallRule;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRulePredicates {
    private static final Logger _logger = LoggerFactory.getLogger(AclRulePredicates.class);
    private static final String SEPARATOR = ",";
    private ObjectProperties _properties = new ObjectProperties();
    private FirewallRule _firewallRule;
    private FirewallRuleFactory _firewallRuleFactory = new FirewallRuleFactory();

    public void parse(String key, String value) {
        ObjectProperties.Property property = ObjectProperties.Property.parse((String)key);
        if (property == ObjectProperties.Property.FROM_HOSTNAME) {
            this.checkFirewallRuleNotAlreadyDefined(key, value);
            this._firewallRule = this._firewallRuleFactory.createForHostname(value.split(SEPARATOR));
        } else if (property == ObjectProperties.Property.FROM_NETWORK) {
            this.checkFirewallRuleNotAlreadyDefined(key, value);
            this._firewallRule = this._firewallRuleFactory.createForNetwork(value.split(SEPARATOR));
        } else {
            this._properties.put(property, value);
        }
        _logger.debug("Parsed {} with value {}", (Object)property, (Object)value);
    }

    private void checkFirewallRuleNotAlreadyDefined(String key, String value) {
        if (this._firewallRule != null) {
            throw new IllegalStateException("Cannot parse " + key + "=" + value + " because firewall rule " + this._firewallRule + " has already been defined");
        }
    }

    public String toString() {
        return "AclRulePredicates[properties=" + this._properties + ", firewallRule=" + this._firewallRule + ']';
    }

    public FirewallRule getFirewallRule() {
        return this._firewallRule;
    }

    public ObjectProperties getObjectProperties() {
        return this._properties;
    }

    void setFirewallRuleFactory(FirewallRuleFactory firewallRuleFactory) {
        this._firewallRuleFactory = firewallRuleFactory;
    }
}

