/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.PlainConfiguration;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessControl
implements AccessControl {
    private static final Logger _logger = LoggerFactory.getLogger(DefaultAccessControl.class);
    private final String _fileName;
    private RuleSet _ruleSet;
    private final EventLoggerProvider _eventLogger;

    public DefaultAccessControl(String name, EventLoggerProvider eventLogger) {
        this._fileName = name;
        this._eventLogger = eventLogger;
        _logger.debug("Creating AccessControl instance");
    }

    DefaultAccessControl(RuleSet rs) {
        this._fileName = null;
        this._ruleSet = rs;
        this._eventLogger = rs;
    }

    public void open() {
        if (this._fileName != null) {
            PlainConfiguration configFile = new PlainConfiguration(this._fileName, this._eventLogger);
            this._ruleSet = configFile.load(DefaultAccessControl.getReaderFromURLString(this._fileName));
        }
    }

    public boolean validate() {
        try {
            DefaultAccessControl.getReaderFromURLString(this._fileName);
            return true;
        }
        catch (IllegalConfigurationException e) {
            return false;
        }
    }

    private static Reader getReaderFromURLString(String urlString) {
        try {
            URL url;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                File file = new File(urlString);
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException notAFile) {
                    throw new IllegalConfigurationException("Cannot convert " + urlString + " to a readable resource", (Throwable)notAFile);
                }
            }
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot convert " + urlString + " to a readable resource", (Throwable)e);
        }
    }

    public void close() {
    }

    public void onDelete() {
    }

    public void onCreate() {
        if (this._fileName != null) {
            new PlainConfiguration(this._fileName, this._eventLogger).load(DefaultAccessControl.getReaderFromURLString(this._fileName));
        }
    }

    public Result getDefault() {
        return this._ruleSet.getDefault();
    }

    public Result authorise(Operation operation, ObjectType objectType, ObjectProperties properties) {
        SocketAddress address;
        InetAddress addressOfClient = null;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.getPrincipals().size() == 0) {
            return Result.ABSTAIN;
        }
        Set<ConnectionPrincipal> principals = subject.getPrincipals(ConnectionPrincipal.class);
        if (!principals.isEmpty() && (address = principals.iterator().next().getConnection().getRemoteSocketAddress()) instanceof InetSocketAddress) {
            addressOfClient = ((InetSocketAddress)address).getAddress();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Checking " + operation + " " + objectType + " " + (addressOfClient == null ? "" : addressOfClient));
        }
        try {
            return this._ruleSet.check(subject, operation, objectType, properties, addressOfClient);
        }
        catch (Exception e) {
            _logger.error("Unable to check " + operation + " " + objectType + " " + (addressOfClient == null ? "" : addressOfClient), (Throwable)e);
            return Result.DENIED;
        }
    }
}

