/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.Action;

public class Rule {
    public static final String ALL = "all";
    private Integer _number;
    private String _identity;
    private AclAction _action;
    private Permission _permission;
    private Boolean _enabled = Boolean.TRUE;

    public Rule(Integer number, String identity, AclAction action, Permission permission) {
        this.setNumber(number);
        this.setIdentity(identity);
        this.setAction(action);
        this.setPermission(permission);
    }

    public Rule(String identity, AclAction action, Permission permission) {
        this(null, identity, action, permission);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void enable() {
        this._enabled = Boolean.TRUE;
    }

    public void disable() {
        this._enabled = Boolean.FALSE;
    }

    public Integer getNumber() {
        return this._number;
    }

    public void setNumber(Integer number) {
        this._number = number;
    }

    public String getIdentity() {
        return this._identity;
    }

    public void setIdentity(String identity) {
        this._identity = identity;
    }

    public Action getAction() {
        return this._action.getAction();
    }

    public AclAction getAclAction() {
        return this._action;
    }

    public void setAction(AclAction action) {
        this._action = action;
    }

    public Permission getPermission() {
        return this._permission;
    }

    public void setPermission(Permission permission) {
        this._permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.getNumber() != null ? !this.getNumber().equals(rule.getNumber()) : rule.getNumber() != null) {
            return false;
        }
        if (this.getIdentity() != null ? !this.getIdentity().equals(rule.getIdentity()) : rule.getIdentity() != null) {
            return false;
        }
        if (this.getAction() != null ? !this.getAction().equals(rule.getAction()) : rule.getAction() != null) {
            return false;
        }
        return this.getPermission() == rule.getPermission();
    }

    public int hashCode() {
        int result = this.getNumber() != null ? this.getNumber().hashCode() : 0;
        result = 31 * result + (this.getIdentity() != null ? this.getIdentity().hashCode() : 0);
        result = 31 * result + (this.getAction() != null ? this.getAction().hashCode() : 0);
        result = 31 * result + (this.getPermission() != null ? this.getPermission().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule[#=" + this._number + ", identity='" + this._identity + '\'' + ", action=" + this._action + ", permission=" + this._permission + ", enabled=" + this._enabled + ']';
    }
}

