/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.access.plugins.ACLFileAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.DefaultAccessControl;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLFileAccessControlProviderImpl
extends AbstractConfiguredObject<ACLFileAccessControlProviderImpl>
implements ACLFileAccessControlProvider<ACLFileAccessControlProviderImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACLFileAccessControlProviderImpl.class);
    protected DefaultAccessControl _accessControl;
    protected final Broker _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField(afterSet="reloadAclFile")
    private String _path;

    @ManagedObjectFactoryConstructor
    public ACLFileAccessControlProviderImpl(Map<String, Object> attributes, Broker broker) {
        super(ACLFileAccessControlProviderImpl.parentsMap((ConfiguredObject[])new ConfiguredObject[]{broker}), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(AccessControlMessages.CREATE((String)this.getName()));
    }

    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    protected void validateOnCreate() {
        try (DefaultAccessControl accessControl = null;){
            accessControl = new DefaultAccessControl(this.getPath(), (EventLoggerProvider)this._broker);
            accessControl.validate();
            accessControl.open();
        }
    }

    protected void onOpen() {
        super.onOpen();
        this._accessControl = new DefaultAccessControl(this.getPath(), (EventLoggerProvider)this._broker);
    }

    private void reloadAclFile() {
        try {
            DefaultAccessControl accessControl = new DefaultAccessControl(this.getPath(), (EventLoggerProvider)this._broker);
            accessControl.open();
            DefaultAccessControl oldAccessControl = this._accessControl;
            this._accessControl = accessControl;
            if (oldAccessControl != null) {
                oldAccessControl.close();
            }
        }
        catch (RuntimeException e) {
            throw new IllegalConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getPath() {
        return this._path;
    }

    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        if (this._broker.isManagementMode()) {
            this.setState(this._accessControl.validate() ? State.QUIESCED : State.ERRORED);
        } else {
            try {
                this._accessControl.open();
                this.setState(State.ACTIVE);
            }
            catch (RuntimeException e) {
                this.setState(State.ERRORED);
                if (this._broker.isManagementMode()) {
                    LOGGER.warn("Failed to activate ACL provider: " + this.getName(), (Throwable)e);
                }
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    protected void onClose() {
        super.onClose();
        if (this._accessControl != null) {
            this._accessControl.close();
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        return this.doAfterAlways(this.closeAsync(), new Runnable(){

            @Override
            public void run() {
                ACLFileAccessControlProviderImpl.this.setState(State.DELETED);
                ACLFileAccessControlProviderImpl.this.deleted();
                ACLFileAccessControlProviderImpl.this._eventLogger.message(AccessControlMessages.DELETE((String)ACLFileAccessControlProviderImpl.this.getName()));
            }
        });
    }

    public AccessControl getAccessControl() {
        return this._accessControl;
    }

    static {
        Handler.register();
    }
}

