/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.EnumSet;
import java.util.Set;
import org.apache.qpid.server.security.access.config.LegacyOperation;

public enum ObjectType {
    ALL(EnumSet.allOf(LegacyOperation.class)),
    VIRTUALHOSTNODE(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE),
    VIRTUALHOST(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE, LegacyOperation.ACCESS_LOGS),
    MANAGEMENT(LegacyOperation.ALL, LegacyOperation.ACCESS),
    QUEUE(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.PURGE, LegacyOperation.CONSUME, LegacyOperation.UPDATE),
    EXCHANGE(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.BIND, LegacyOperation.UNBIND, LegacyOperation.PUBLISH, LegacyOperation.UPDATE),
    METHOD(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.UPDATE),
    USER(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE),
    GROUP(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE),
    BROKER(LegacyOperation.ALL, LegacyOperation.CONFIGURE, LegacyOperation.ACCESS_LOGS, LegacyOperation.SHUTDOWN);

    private EnumSet<LegacyOperation> _operations;

    private ObjectType(LegacyOperation first, LegacyOperation ... rest) {
        this(EnumSet.of(first, rest));
    }

    private ObjectType(EnumSet<LegacyOperation> operations) {
        this._operations = operations;
    }

    public Set<LegacyOperation> getOperations() {
        return this._operations;
    }

    public boolean isSupported(LegacyOperation operation) {
        return this._operations.contains((Object)operation);
    }

    public String toString() {
        String name = this.name();
        return name.charAt(0) + name.substring(1).toLowerCase();
    }
}

