/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.VirtualHostLogInclusionRule;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.LegacyAccessControl;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.OperationLoggingDetails;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

class LegacyAccessControlAdapter {
    private static final Set<String> LOG_ACCESS_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getFile", "getFiles", "getAllFiles", "getLogEntries")));
    private static final Set<String> QUEUE_UPDATE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("moveMessages", "copyMessages", "deleteMessages")));
    private static final Set<String> LEGACY_PREFERENCES_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getPreferences", "setPreferences", "deletePreferences")));
    private static final Set<String> BDB_VIRTUAL_HOST_NODE_OPERATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("updateMutableConfig", "cleanLog", "checkpoint")));
    private static final Set<String> BROKER_CONFIGURE_OPERATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("setJVMOptions", "dumpHeap", "performGC", "getThreadStackTraces", "findThreadStackTraces", "extractConfig")));
    private static final Set<String> VIRTUALHOST_UPDATE_OPERATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("importMessageStore", "extractMessageStore")));
    private final LegacyAccessControl _accessControl;
    private final Model _model;

    LegacyAccessControlAdapter(LegacyAccessControl accessControl, Model model) {
        this._accessControl = accessControl;
        this._model = model;
    }

    private Model getModel() {
        return this._model;
    }

    Result authorise(LegacyOperation operation, PermissionedObject configuredObject) {
        if (this.isAllowedOperation(operation, configuredObject)) {
            return Result.ALLOWED;
        }
        Class categoryClass = configuredObject.getCategoryClass();
        ObjectType objectType = this.getACLObjectTypeManagingConfiguredObjectOfCategory(categoryClass);
        if (objectType == null) {
            throw new IllegalArgumentException("Cannot identify object type for category " + categoryClass);
        }
        ObjectProperties properties = this.getACLObjectProperties(configuredObject, operation);
        LegacyOperation authoriseOperation = this.validateAuthoriseOperation(operation, categoryClass);
        return this._accessControl.authorise(authoriseOperation, objectType, properties);
    }

    private boolean isAllowedOperation(LegacyOperation operation, PermissionedObject configuredObject) {
        if (configuredObject instanceof Session && (operation == LegacyOperation.CREATE || operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE)) {
            return true;
        }
        if (configuredObject instanceof Consumer && (operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE)) {
            return true;
        }
        return configuredObject instanceof Connection && (operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE);
    }

    private ObjectType getACLObjectTypeManagingConfiguredObjectOfCategory(Class<? extends ConfiguredObject> category) {
        if (Binding.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (VirtualHostNode.class.isAssignableFrom(category)) {
            return ObjectType.VIRTUALHOSTNODE;
        }
        if (this.isBrokerType(category)) {
            return ObjectType.BROKER;
        }
        if (this.isVirtualHostType(category)) {
            return ObjectType.VIRTUALHOST;
        }
        if (Group.class.isAssignableFrom(category)) {
            return ObjectType.GROUP;
        }
        if (GroupMember.class.isAssignableFrom(category)) {
            return ObjectType.GROUP;
        }
        if (User.class.isAssignableFrom(category)) {
            return ObjectType.USER;
        }
        if (Queue.class.isAssignableFrom(category)) {
            return ObjectType.QUEUE;
        }
        if (Exchange.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (Session.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (Consumer.class.isAssignableFrom(category)) {
            return ObjectType.QUEUE;
        }
        if (RemoteReplicationNode.class.isAssignableFrom(category)) {
            return ObjectType.VIRTUALHOSTNODE;
        }
        return null;
    }

    private boolean isVirtualHostType(Class<? extends ConfiguredObject> category) {
        return VirtualHost.class.isAssignableFrom(category) || VirtualHostLogger.class.isAssignableFrom(category) || VirtualHostLogInclusionRule.class.isAssignableFrom(category) || VirtualHostAccessControlProvider.class.isAssignableFrom(category) || Connection.class.isAssignableFrom(category);
    }

    private boolean isBrokerType(Class<? extends ConfiguredObject> category) {
        return Broker.class.isAssignableFrom(category) || BrokerLogInclusionRule.class.isAssignableFrom(category) || VirtualHostAlias.class.isAssignableFrom(category) || !VirtualHostNode.class.isAssignableFrom(category) && this.getModel().getChildTypes(Broker.class).contains(category);
    }

    private ObjectProperties getACLObjectProperties(PermissionedObject configuredObject, LegacyOperation configuredObjectOperation) {
        String objectName = configuredObject.getName();
        Class configuredObjectType = configuredObject.getCategoryClass();
        ObjectProperties properties = new ObjectProperties(objectName);
        if (configuredObject instanceof Binding) {
            Exchange exchange = (Exchange)((Binding)configuredObject).getParent(Exchange.class);
            Queue queue = (Queue)((Binding)configuredObject).getParent(Queue.class);
            properties.setName((String)exchange.getAttribute("name"));
            properties.put(ObjectProperties.Property.QUEUE_NAME, (String)queue.getAttribute("name"));
            properties.put(ObjectProperties.Property.ROUTING_KEY, objectName);
            properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)((VirtualHost)queue.getParent(VirtualHost.class)).getAttribute("name"));
            properties.put(ObjectProperties.Property.TEMPORARY, queue.getAttribute("lifetimePolicy") != LifetimePolicy.PERMANENT);
            properties.put(ObjectProperties.Property.DURABLE, (Boolean)queue.getAttribute("durable"));
        } else if (configuredObject instanceof Queue) {
            this.setQueueProperties((ConfiguredObject<?>)((Queue)configuredObject), properties);
        } else if (configuredObject instanceof Exchange) {
            Exchange exchange = (Exchange)configuredObject;
            Object lifeTimePolicy = exchange.getAttribute("lifetimePolicy");
            properties.put(ObjectProperties.Property.AUTO_DELETE, lifeTimePolicy != LifetimePolicy.PERMANENT);
            properties.put(ObjectProperties.Property.TEMPORARY, lifeTimePolicy != LifetimePolicy.PERMANENT);
            properties.put(ObjectProperties.Property.DURABLE, (Boolean)exchange.getAttribute("durable"));
            properties.put(ObjectProperties.Property.TYPE, (String)exchange.getAttribute("type"));
            VirtualHost virtualHost = (VirtualHost)exchange.getParent(VirtualHost.class);
            properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
        } else if (configuredObject instanceof QueueConsumer) {
            Queue queue = (Queue)((QueueConsumer)configuredObject).getParent(Queue.class);
            this.setQueueProperties((ConfiguredObject<?>)queue, properties);
        } else if (this.isBrokerType(configuredObjectType)) {
            String description = String.format("%s %s '%s'", configuredObjectOperation == null ? null : configuredObjectOperation.name().toLowerCase(), configuredObjectType == null ? null : configuredObjectType.getSimpleName().toLowerCase(), objectName);
            properties = new OperationLoggingDetails(description);
        } else if (this.isVirtualHostType(configuredObjectType)) {
            ConfiguredObject virtualHost = (ConfiguredObject)this.getModel().getAncestor(VirtualHost.class, (ConfiguredObject)configuredObject);
            properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
        }
        return properties;
    }

    private void setQueueProperties(ConfiguredObject<?> queue, ObjectProperties properties) {
        String owner;
        properties.setName((String)queue.getAttribute("name"));
        Object lifeTimePolicy = queue.getAttribute("lifetimePolicy");
        properties.put(ObjectProperties.Property.AUTO_DELETE, lifeTimePolicy != LifetimePolicy.PERMANENT);
        properties.put(ObjectProperties.Property.TEMPORARY, lifeTimePolicy != LifetimePolicy.PERMANENT);
        properties.put(ObjectProperties.Property.DURABLE, (Boolean)queue.getAttribute("durable"));
        properties.put(ObjectProperties.Property.EXCLUSIVE, queue.getAttribute("exclusive") != ExclusivityPolicy.NONE);
        Object alternateExchange = queue.getAttribute("alternateExchange");
        if (alternateExchange != null) {
            String name = alternateExchange instanceof ConfiguredObject ? (String)((ConfiguredObject)alternateExchange).getAttribute("name") : String.valueOf(alternateExchange);
            properties.put(ObjectProperties.Property.ALTERNATE, name);
        }
        if ((owner = (String)queue.getAttribute("owner")) != null) {
            properties.put(ObjectProperties.Property.OWNER, owner);
        }
        VirtualHost virtualHost = (VirtualHost)queue.getParent(VirtualHost.class);
        properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
    }

    private LegacyOperation validateAuthoriseOperation(LegacyOperation operation, Class<? extends ConfiguredObject> category) {
        if (operation == LegacyOperation.CREATE || operation == LegacyOperation.UPDATE) {
            if (Binding.class.isAssignableFrom(category)) {
                return LegacyOperation.BIND;
            }
            if (Consumer.class.isAssignableFrom(category)) {
                return LegacyOperation.CONSUME;
            }
            if (GroupMember.class.isAssignableFrom(category)) {
                return LegacyOperation.UPDATE;
            }
            if (this.isBrokerType(category)) {
                return LegacyOperation.CONFIGURE;
            }
        } else if (operation == LegacyOperation.DELETE) {
            if (Binding.class.isAssignableFrom(category)) {
                return LegacyOperation.UNBIND;
            }
            if (this.isBrokerType(category)) {
                return LegacyOperation.CONFIGURE;
            }
            if (GroupMember.class.isAssignableFrom(category)) {
                return LegacyOperation.UPDATE;
            }
        }
        return operation;
    }

    Result authoriseAction(PermissionedObject configuredObject, String actionName, Map<String, Object> arguments) {
        Class categoryClass = configuredObject.getCategoryClass();
        if (categoryClass == Exchange.class) {
            MessageDestination exchange = (MessageDestination)configuredObject;
            if ("publish".equals(actionName)) {
                ObjectProperties _props = new ObjectProperties(exchange.getAddressSpace().getName(), exchange.getName(), (String)arguments.get("routingKey"), (Boolean)arguments.get("immediate"));
                return this._accessControl.authorise(LegacyOperation.PUBLISH, ObjectType.EXCHANGE, _props);
            }
        } else if (categoryClass == VirtualHost.class) {
            if ("connect".equals(actionName)) {
                String virtualHostName = configuredObject.getName();
                ObjectProperties properties = new ObjectProperties(virtualHostName);
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualHostName);
                return this._accessControl.authorise(LegacyOperation.ACCESS, ObjectType.VIRTUALHOST, properties);
            }
        } else if (categoryClass == Broker.class) {
            if ("manage".equals(actionName)) {
                return this._accessControl.authorise(LegacyOperation.ACCESS, ObjectType.MANAGEMENT, ObjectProperties.EMPTY);
            }
            if ("CONFIGURE".equals(actionName) || "SHUTDOWN".equals(actionName)) {
                return this._accessControl.authorise(LegacyOperation.valueOf(actionName), ObjectType.BROKER, ObjectProperties.EMPTY);
            }
        } else if (categoryClass == Queue.class) {
            Queue queue = (Queue)configuredObject;
            if ("publish".equals(actionName)) {
                ObjectProperties _props = new ObjectProperties(queue.getParent(VirtualHost.class).getName(), "", queue.getName(), (Boolean)arguments.get("immediate"));
                return this._accessControl.authorise(LegacyOperation.PUBLISH, ObjectType.EXCHANGE, _props);
            }
        }
        return Result.DEFER;
    }

    Result authoriseMethod(PermissionedObject configuredObject, String methodName, Map<String, Object> arguments) {
        Class categoryClass = configuredObject.getCategoryClass();
        if (categoryClass == Queue.class) {
            Queue queue = (Queue)configuredObject;
            ObjectProperties properties = new ObjectProperties();
            if ("clearQueue".equals(methodName)) {
                this.setQueueProperties((ConfiguredObject<?>)queue, properties);
                return this._accessControl.authorise(LegacyOperation.PURGE, ObjectType.QUEUE, properties);
            }
            if (QUEUE_UPDATE_METHODS.contains(methodName)) {
                VirtualHost virtualHost = queue.getVirtualHost();
                String virtualHostName = virtualHost.getName();
                properties.setName(methodName);
                properties.put(ObjectProperties.Property.COMPONENT, "VirtualHost.Queue");
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualHostName);
                return this._accessControl.authorise(LegacyOperation.UPDATE, ObjectType.METHOD, properties);
            }
            if ("publish".equals(methodName)) {
                ObjectProperties _props = new ObjectProperties(queue.getParent(VirtualHost.class).getName(), "", queue.getName(), (Boolean)arguments.get("immediate"));
                return this._accessControl.authorise(LegacyOperation.PUBLISH, ObjectType.EXCHANGE, _props);
            }
        } else if (categoryClass == BrokerLogger.class) {
            if (LOG_ACCESS_METHOD_NAMES.contains(methodName)) {
                return this._accessControl.authorise(LegacyOperation.ACCESS_LOGS, ObjectType.BROKER, ObjectProperties.EMPTY);
            }
        } else if (categoryClass == VirtualHostLogger.class) {
            VirtualHostLogger logger = (VirtualHostLogger)configuredObject;
            if (LOG_ACCESS_METHOD_NAMES.contains(methodName)) {
                return this._accessControl.authorise(LegacyOperation.ACCESS_LOGS, ObjectType.VIRTUALHOST, new ObjectProperties(logger.getParent(VirtualHost.class).getName()));
            }
        } else if (categoryClass == AuthenticationProvider.class) {
            if (LEGACY_PREFERENCES_METHOD_NAMES.contains(methodName) && arguments.get("userId") instanceof String) {
                String userName = (String)arguments.get("userId");
                AuthenticatedPrincipal principal = AuthenticatedPrincipal.getCurrentUser();
                if (principal != null && principal.getName().equals(userName)) {
                    return Result.ALLOWED;
                }
                return this._accessControl.authorise(LegacyOperation.UPDATE, ObjectType.USER, new ObjectProperties(userName));
            }
        } else if (categoryClass == VirtualHostNode.class) {
            if (BDB_VIRTUAL_HOST_NODE_OPERATIONS.contains(methodName)) {
                ObjectProperties properties = this.getACLObjectProperties((PermissionedObject)((ConfiguredObject)configuredObject).getParent(Broker.class), LegacyOperation.UPDATE);
                return this._accessControl.authorise(LegacyOperation.UPDATE, ObjectType.BROKER, properties);
            }
        } else if (categoryClass == Broker.class) {
            if (BROKER_CONFIGURE_OPERATIONS.contains(methodName)) {
                this._accessControl.authorise(LegacyOperation.CONFIGURE, ObjectType.BROKER, ObjectProperties.EMPTY);
            } else if ("initiateShutdown".equals(methodName)) {
                this._accessControl.authorise(LegacyOperation.SHUTDOWN, ObjectType.BROKER, ObjectProperties.EMPTY);
            }
        } else if (categoryClass == VirtualHost.class && VIRTUALHOST_UPDATE_OPERATIONS.contains(methodName)) {
            this.authorise(LegacyOperation.UPDATE, configuredObject);
        }
        return Result.ALLOWED;
    }

    Result authorise(Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        switch (operation.getType()) {
            case CREATE: {
                return this.authorise(LegacyOperation.CREATE, configuredObject);
            }
            case UPDATE: {
                return this.authorise(LegacyOperation.UPDATE, configuredObject);
            }
            case DELETE: {
                return this.authorise(LegacyOperation.DELETE, configuredObject);
            }
            case METHOD: {
                return this.authoriseMethod(configuredObject, operation.getName(), arguments);
            }
            case ACTION: {
                return this.authoriseAction(configuredObject, operation.getName(), arguments);
            }
            case DISCOVER: 
            case READ: {
                return Result.DEFER;
            }
        }
        return null;
    }
}

