/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import com.google.common.collect.Sets;
import java.util.Map;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.firewall.FirewallRule;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRulePredicates {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclRulePredicates.class);
    private static final String SEPARATOR = ",";
    private ObjectProperties _properties = new ObjectProperties();
    private FirewallRule _firewallRule;
    private FirewallRuleFactory _firewallRuleFactory = new FirewallRuleFactory();

    public AclRulePredicates() {
    }

    public AclRulePredicates(Map<ObjectProperties.Property, String> values) {
        if (values != null) {
            for (Map.Entry<ObjectProperties.Property, String> entry : values.entrySet()) {
                this.addPropertyValue(entry.getKey(), entry.getValue());
            }
        }
    }

    public void parse(String key, String value) {
        ObjectProperties.Property property = ObjectProperties.Property.parse(key);
        this.addPropertyValue(property, value);
        LOGGER.debug("Parsed {} with value {}", (Object)property, (Object)value);
    }

    private void addPropertyValue(ObjectProperties.Property property, String value) {
        if (property == ObjectProperties.Property.FROM_HOSTNAME) {
            this.checkFirewallRuleNotAlreadyDefined(property.name(), value);
            this._firewallRule = this._firewallRuleFactory.createForHostname(value.split(SEPARATOR));
        } else if (property == ObjectProperties.Property.FROM_NETWORK) {
            this.checkFirewallRuleNotAlreadyDefined(property.name(), value);
            this._firewallRule = this._firewallRuleFactory.createForNetwork(value.split(SEPARATOR));
        } else if (property == ObjectProperties.Property.ATTRIBUTES) {
            this._properties.setAttributeNames(Sets.newHashSet((Object[])value.split(SEPARATOR)));
        } else {
            this._properties.put(property, value);
        }
    }

    private void checkFirewallRuleNotAlreadyDefined(String key, String value) {
        if (this._firewallRule != null) {
            throw new IllegalStateException("Cannot parse " + key + "=" + value + " because firewall rule " + this._firewallRule + " has already been defined");
        }
    }

    public String toString() {
        return "AclRulePredicates[properties=" + this._properties + ", firewallRule=" + this._firewallRule + ']';
    }

    public FirewallRule getFirewallRule() {
        return this._firewallRule;
    }

    public ObjectProperties getObjectProperties() {
        return this._properties;
    }

    void setFirewallRuleFactory(FirewallRuleFactory firewallRuleFactory) {
        this._firewallRuleFactory = firewallRuleFactory;
    }
}

