/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.security.access.firewall.FirewallRule;
import org.apache.qpid.server.security.access.firewall.InetNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFirewallRule
implements FirewallRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkFirewallRule.class);
    private List<InetNetwork> _networks = new ArrayList<InetNetwork>();

    public NetworkFirewallRule(String ... networks) {
        for (int i = 0; i < networks.length; ++i) {
            String network = networks[i];
            try {
                InetNetwork inetNetwork = InetNetwork.getFromString(network);
                if (this._networks.contains(inetNetwork)) continue;
                this._networks.add(inetNetwork);
                continue;
            }
            catch (UnknownHostException uhe) {
                LOGGER.error("Cannot resolve address: " + network, (Throwable)uhe);
            }
        }
        LOGGER.debug("Created {}", (Object)this);
    }

    @Override
    public boolean matches(InetAddress ip) {
        for (InetNetwork network : this._networks) {
            if (!network.contains(ip)) continue;
            LOGGER.debug("Client address {} matches configured network {}", (Object)ip, (Object)network);
            return true;
        }
        LOGGER.debug("Client address {} does not match any configured networks", (Object)ip);
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkFirewallRule that = (NetworkFirewallRule)o;
        return !(this._networks == null ? that._networks != null : !this._networks.equals(that._networks));
    }

    public int hashCode() {
        return this._networks != null ? this._networks.hashCode() : 0;
    }

    public String toString() {
        return "NetworkFirewallRule[networks=" + this._networks + ']';
    }
}

