/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectProperties.class);
    static final String WILD_CARD = "*";
    static final ObjectProperties EMPTY = new ObjectProperties();
    private Set<String> _attributeNames;
    private final EnumMap<Property, String> _properties = new EnumMap(Property.class);

    public ObjectProperties() {
    }

    public ObjectProperties(Property property, String value) {
        this._properties.put(property, value);
    }

    public ObjectProperties(ObjectProperties copy) {
        this._properties.putAll(copy._properties);
    }

    public ObjectProperties(String name) {
        this.setName(name);
    }

    public ObjectProperties(String virtualHostName, String exchangeName, String routingKey) {
        this.setName(exchangeName);
        this.put(Property.ROUTING_KEY, routingKey);
        this.put(Property.VIRTUALHOST_NAME, virtualHostName);
    }

    public Boolean isSet(Property key) {
        return this._properties.containsKey((Object)key) && Boolean.valueOf(this._properties.get((Object)key)) != false;
    }

    public String get(Property key) {
        return this._properties.get((Object)key);
    }

    public String getName() {
        return this._properties.get((Object)Property.NAME);
    }

    public void setName(String name) {
        this._properties.put(Property.NAME, name);
    }

    Set<String> getAttributeNames() {
        return this._attributeNames;
    }

    void setAttributeNames(Set<String> attributeNames) {
        this._attributeNames = attributeNames == null ? null : new HashSet<String>(attributeNames);
    }

    public String put(Property key, String value) {
        return this._properties.put(key, value == null ? "" : value.trim());
    }

    public void put(Property key, Boolean value) {
        if (value != null) {
            this._properties.put(key, Boolean.toString(value));
        }
    }

    boolean propertiesMatch(ObjectProperties other) {
        if (other._properties.keySet().isEmpty()) {
            return true;
        }
        if (!this._properties.keySet().containsAll(other._properties.keySet())) {
            return false;
        }
        for (Map.Entry<Property, String> entry : other._properties.entrySet()) {
            Property key = entry.getKey();
            String ruleValue = entry.getValue();
            String thisValue = this._properties.get((Object)key);
            if (this.valueMatches(thisValue, ruleValue)) continue;
            return false;
        }
        return true;
    }

    boolean attributesMatch(ObjectProperties other) {
        return other._attributeNames == null || this._attributeNames != null && other._attributeNames.containsAll(this._attributeNames);
    }

    private boolean valueMatches(String thisValue, String ruleValue) {
        return ruleValue == null || ruleValue.equals("") || ruleValue.equals(thisValue) || ruleValue.equals(WILD_CARD) || ruleValue.endsWith(WILD_CARD) && thisValue != null && thisValue.length() >= ruleValue.length() - 1 && thisValue.startsWith(ruleValue.substring(0, ruleValue.length() - 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectProperties that = (ObjectProperties)o;
        if (this._attributeNames != null ? !this._attributeNames.equals(that._attributeNames) : that._attributeNames != null) {
            return false;
        }
        return this._properties != null ? this._properties.equals((Object)that._properties) : that._properties == null;
    }

    public int hashCode() {
        int result = this._attributeNames != null ? this._attributeNames.hashCode() : 0;
        result = 31 * result + (this._properties != null ? this._properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Joiner joiner = Joiner.on((String)",");
        joiner.withKeyValueSeparator("=").appendTo(sb, this._properties);
        if (this._attributeNames != null && !this._attributeNames.isEmpty()) {
            if (!this._properties.isEmpty()) {
                sb.append(",");
            }
            sb.append("ATTRIBUTES=[");
            joiner.appendTo(sb, this._attributeNames);
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this._properties.isEmpty();
    }

    public Map<Property, String> asPropertyMap() {
        return Collections.unmodifiableMap(this._properties);
    }

    public static enum Property {
        ROUTING_KEY,
        NAME,
        QUEUE_NAME,
        OWNER,
        TYPE,
        ALTERNATE,
        DURABLE,
        EXCLUSIVE,
        TEMPORARY,
        AUTO_DELETE,
        COMPONENT,
        PACKAGE,
        CLASS,
        FROM_NETWORK,
        FROM_HOSTNAME,
        VIRTUALHOST_NAME,
        METHOD_NAME,
        ATTRIBUTES;

        private static final Map<String, Property> _canonicalNameToPropertyMap;

        public static Property parse(String text) {
            String propertyName = Property.getCanonicalName(text);
            Property property = _canonicalNameToPropertyMap.get(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Not a valid property: " + text + " because " + propertyName + " is not in " + _canonicalNameToPropertyMap.keySet());
            }
            return property;
        }

        public String getCanonicalName() {
            return Property.getCanonicalName(this.name());
        }

        private static String getCanonicalName(String name) {
            return name.replace("_", "").toLowerCase();
        }

        static {
            _canonicalNameToPropertyMap = new HashMap<String, Property>();
            for (Property property : Property.values()) {
                _canonicalNameToPropertyMap.put(property.getCanonicalName(), property);
            }
        }
    }
}

