/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.net.InetAddress;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.firewall.FirewallRule;

public class ClientAction {
    private Action _clientAction;

    public ClientAction(Action clientAction) {
        this._clientAction = clientAction;
    }

    public ClientAction(LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
        this._clientAction = new Action(operation, objectType, properties);
    }

    public boolean matches(AclAction ruleAction, InetAddress addressOfClient) {
        return this._clientAction.matches(ruleAction.getAction()) && this.addressOfClientMatches(ruleAction, addressOfClient);
    }

    private boolean addressOfClientMatches(AclAction ruleAction, InetAddress addressOfClient) {
        FirewallRule firewallRule = ruleAction.getFirewallRule();
        if (firewallRule == null || addressOfClient == null) {
            return true;
        }
        return firewallRule.matches(addressOfClient);
    }

    public LegacyOperation getOperation() {
        return this._clientAction.getOperation();
    }

    public ObjectType getObjectType() {
        return this._clientAction.getObjectType();
    }

    public ObjectProperties getProperties() {
        return this._clientAction.getProperties();
    }

    public String toString() {
        return "ClientAction[clientAction=" + this._clientAction + ']';
    }
}

