/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config.connection;

import javax.security.auth.Subject;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.security.access.config.DynamicRule;
import org.apache.qpid.server.transport.AMQPConnection;

public abstract class ConnectionPrincipalStatisticsRule
implements DynamicRule {
    private final int _limit;

    ConnectionPrincipalStatisticsRule(int limit) {
        this._limit = limit;
    }

    int getLimit() {
        return this._limit;
    }

    @Override
    public boolean matches(Subject subject) {
        AMQPConnection<?> connection = this.getConnection(subject);
        if (connection != null) {
            return this.matches(connection);
        }
        return false;
    }

    abstract boolean matches(AMQPConnection<?> var1);

    private AMQPConnection<?> getConnection(Subject subject) {
        ConnectionPrincipal principal;
        if (subject != null && (principal = (ConnectionPrincipal)subject.getPrincipals(ConnectionPrincipal.class).stream().findFirst().orElse(null)) != null) {
            return principal.getConnection();
        }
        return null;
    }
}

