/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.server.security.access.util.AbstractTreeBranch;
import org.apache.qpid.server.security.access.util.FinalBranch;
import org.apache.qpid.server.security.access.util.PrefixTree;
import org.apache.qpid.server.security.access.util.TreeBranch;
import org.apache.qpid.server.security.access.util.TreeRoot;

final class WildCardBranch
extends AbstractTreeBranch {
    WildCardBranch(String prefix) {
        super(prefix);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Map<Character, PrefixTree> branches() {
        return Collections.emptyMap();
    }

    @Override
    boolean contains(String str) {
        return str.startsWith(this._prefix);
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.singletonIterator((Object)(this._prefix + "*"));
    }

    @Override
    AbstractTreeBranch mergeString(String str) {
        String common = Strings.commonPrefix((CharSequence)str, (CharSequence)this._prefix);
        if (common.isEmpty()) {
            return new TreeRoot(this, (AbstractTreeBranch)new FinalBranch(str));
        }
        int commonLength = common.length();
        if (commonLength == this._length) {
            return this;
        }
        if (commonLength == str.length()) {
            return new FinalBranch(common, (AbstractTreeBranch)new WildCardBranch(this._prefix.substring(commonLength)));
        }
        return new TreeBranch(common, new WildCardBranch(this._prefix.substring(commonLength)), new FinalBranch(str.substring(commonLength)));
    }

    @Override
    AbstractTreeBranch mergeWildCard(String prefix) {
        String common = Strings.commonPrefix((CharSequence)prefix, (CharSequence)this._prefix);
        if (common.isEmpty()) {
            return new TreeRoot(this, (AbstractTreeBranch)new WildCardBranch(prefix));
        }
        int commonLength = common.length();
        if (commonLength == this._length) {
            return this;
        }
        if (commonLength == prefix.length()) {
            return new WildCardBranch(prefix);
        }
        return new TreeBranch(common, new WildCardBranch(this._prefix.substring(commonLength)), new WildCardBranch(prefix.substring(commonLength)));
    }
}

