/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;

public class CreditCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager_0_10 {
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public CreditCreditManager(long bytesCredit, long messageCredit) {
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void setCreditLimits(long bytesCredit, long messageCredit) {
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
        this.setSuspended(!this.hasCredit());
    }

    public long getMessageCredit() {
        return this._messageCredit == -1L ? Long.MAX_VALUE : this._messageCredit;
    }

    public long getBytesCredit() {
        return this._bytesCredit == -1L ? Long.MAX_VALUE : this._bytesCredit;
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
    }

    public synchronized void addCredit(long messageCredit, long bytesCredit) {
        boolean notifyIncrease = true;
        if (this._messageCredit >= 0L && messageCredit > 0L) {
            notifyIncrease = this._messageCredit != 0L;
            this._messageCredit += messageCredit;
        }
        if (this._bytesCredit >= 0L && bytesCredit > 0L) {
            notifyIncrease = notifyIncrease && bytesCredit > 0L;
            this._bytesCredit += bytesCredit;
            if (notifyIncrease) {
                this.notifyIncreaseBytesCredit();
            }
        }
        this.setSuspended(!this.hasCredit());
    }

    public void clearCredit() {
        this._bytesCredit = 0L;
        this._messageCredit = 0L;
        this.setSuspended(true);
    }

    public synchronized boolean hasCredit() {
        return this._bytesCredit != 0L && this._messageCredit != 0L;
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._messageCredit >= 0L) {
            if (this._messageCredit > 0L) {
                if (this._bytesCredit < 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (msgSize <= this._bytesCredit) {
                    --this._messageCredit;
                    this._bytesCredit -= msgSize;
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCredit >= 0L) {
            if (msgSize <= this._bytesCredit) {
                this._bytesCredit -= msgSize;
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized void stop() {
        if (this._bytesCredit > 0L) {
            this._bytesCredit = 0L;
        }
        if (this._messageCredit > 0L) {
            this._messageCredit = 0L;
        }
    }
}

