/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.ByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageConverter_v0_10
implements MessageConverter<ServerMessage, MessageTransferMessage> {
    public Class<ServerMessage> getInputClass() {
        return ServerMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(ServerMessage serverMsg, VirtualHost vhost) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final ServerMessage serverMsg) {
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int getContent(int offsetInMessage, ByteBuffer dst) {
                return serverMsg.getContent(dst, offsetInMessage);
            }

            public ByteBuffer getContent(int offsetInMessage, int size) {
                return serverMsg.getContent(offsetInMessage, size);
            }

            public StoreFuture flushToStore() {
                return StoreFuture.IMMEDIATE_FUTURE;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(ServerMessage serverMsg) {
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        int size = (int)serverMsg.getSize();
        ByteBuffer body = ByteBuffer.allocate(size);
        serverMsg.getContent(body, 0);
        body.flip();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setImmediate(serverMsg.isImmediate());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)serverMsg.getMessageHeader().getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getRoutingKey());
        deliveryProps.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        messageProps.setContentEncoding(serverMsg.getMessageHeader().getEncoding());
        messageProps.setContentLength((long)size);
        messageProps.setContentType(serverMsg.getMessageHeader().getMimeType());
        if (serverMsg.getMessageHeader().getCorrelationId() != null) {
            messageProps.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId().getBytes());
        }
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "Unknown to v0-10";
    }
}

