/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v0_10.MessageMetaDataType_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferHeader;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;

public class MessageMetaData_0_10
implements StorableMessageMetaData,
InboundMessage {
    private Header _header;
    private DeliveryProperties _deliveryProps;
    private MessageProperties _messageProps;
    private MessageTransferHeader _messageHeader;
    private long _arrivalTime;
    private int _bodySize;
    private static final int ENCODER_SIZE = 1024;
    public static final MessageMetaDataType.Factory<MessageMetaData_0_10> FACTORY = new MetaDataFactory();
    private static final MessageMetaDataType_0_10 TYPE = new MessageMetaDataType_0_10();
    private volatile ByteBuffer _encoded;
    private Object _connectionReference;

    public MessageMetaData_0_10(MessageTransfer xfr) {
        this(xfr.getHeader(), xfr.getBodySize(), System.currentTimeMillis());
    }

    public MessageMetaData_0_10(Header header, int bodySize, long arrivalTime) {
        this._header = header;
        if (this._header != null) {
            this._deliveryProps = this._header.getDeliveryProperties();
            this._messageProps = this._header.getMessageProperties();
        } else {
            this._deliveryProps = null;
            this._messageProps = null;
        }
        this._messageHeader = new MessageTransferHeader(this._deliveryProps, this._messageProps);
        this._arrivalTime = arrivalTime;
        this._bodySize = bodySize;
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        ByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        return buf.limit();
    }

    private ByteBuffer encodeAsBuffer() {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeInt64(this._arrivalTime);
        encoder.writeInt32(this._bodySize);
        int headersLength = 0;
        if (this._header.getDeliveryProperties() != null) {
            ++headersLength;
        }
        if (this._header.getMessageProperties() != null) {
            ++headersLength;
        }
        if (this._header.getNonStandardProperties() != null) {
            headersLength += this._header.getNonStandardProperties().size();
        }
        encoder.writeInt32(headersLength);
        if (this._header.getDeliveryProperties() != null) {
            encoder.writeStruct32((Struct)this._header.getDeliveryProperties());
        }
        if (this._header.getMessageProperties() != null) {
            encoder.writeStruct32((Struct)this._header.getMessageProperties());
        }
        if (this._header.getNonStandardProperties() != null) {
            for (Struct header : this._header.getNonStandardProperties()) {
                encoder.writeStruct32(header);
            }
        }
        ByteBuffer buf = encoder.buffer();
        return buf;
    }

    public int writeToBuffer(int offsetInMetaData, ByteBuffer dest) {
        ByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        buf = buf.duplicate();
        buf.position(offsetInMetaData);
        if (dest.remaining() < buf.limit()) {
            buf.limit(dest.remaining());
        }
        dest.put(buf);
        return buf.limit();
    }

    public int getContentSize() {
        return this._bodySize;
    }

    public boolean isPersistent() {
        return this._deliveryProps == null ? false : this._deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT;
    }

    public String getRoutingKey() {
        return this._deliveryProps == null ? null : this._deliveryProps.getRoutingKey();
    }

    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this.getRoutingKey());
    }

    public AMQMessageHeader getMessageHeader() {
        return this._messageHeader;
    }

    public long getSize() {
        return this._bodySize;
    }

    public boolean isImmediate() {
        return this._deliveryProps != null && this._deliveryProps.getImmediate();
    }

    public long getExpiration() {
        return this._deliveryProps == null ? 0L : this._deliveryProps.getExpiration();
    }

    public boolean isRedelivered() {
        return false;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public Header getHeader() {
        return this._header;
    }

    public void setConnectionReference(Object connectionReference) {
        this._connectionReference = connectionReference;
    }

    public Object getConnectionReference() {
        return this._connectionReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData_0_10> {
        private MetaDataFactory() {
        }

        public MessageMetaData_0_10 createMetaData(ByteBuffer buf) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(buf);
            long arrivalTime = decoder.readInt64();
            int bodySize = decoder.readInt32();
            int headerCount = decoder.readInt32();
            DeliveryProperties deliveryProperties = null;
            MessageProperties messageProperties = null;
            ArrayList<Struct> otherProps = null;
            for (int i = 0; i < headerCount; ++i) {
                Struct struct = decoder.readStruct32();
                if (struct instanceof DeliveryProperties && deliveryProperties == null) {
                    deliveryProperties = (DeliveryProperties)struct;
                    continue;
                }
                if (struct instanceof MessageProperties && messageProperties == null) {
                    messageProperties = (MessageProperties)struct;
                    continue;
                }
                if (otherProps == null) {
                    otherProps = new ArrayList<Struct>();
                }
                otherProps.add(struct);
            }
            Header header = new Header(deliveryProperties, messageProperties, otherProps);
            return new MessageMetaData_0_10(header, bodySize, arrivalTime);
        }
    }
}

