/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageTransferHeader
implements AMQMessageHeader {
    public static final String JMS_TYPE = "x-jms-type";
    private final DeliveryProperties _deliveryProps;
    private final MessageProperties _messageProps;

    public MessageTransferHeader(DeliveryProperties deliveryProps, MessageProperties messageProps) {
        this._deliveryProps = deliveryProps;
        this._messageProps = messageProps;
    }

    public String getCorrelationId() {
        if (this._messageProps != null && this._messageProps.getCorrelationId() != null) {
            return new String(this._messageProps.getCorrelationId());
        }
        return null;
    }

    public long getExpiration() {
        return this._deliveryProps == null ? 0L : this._deliveryProps.getExpiration();
    }

    public String getUserId() {
        byte[] userIdBytes = this._messageProps == null ? null : this._messageProps.getUserId();
        return userIdBytes == null ? null : new String(userIdBytes);
    }

    public String getAppId() {
        byte[] appIdBytes = this._messageProps == null ? null : this._messageProps.getAppId();
        return appIdBytes == null ? null : new String(appIdBytes);
    }

    public String getMessageId() {
        UUID id = this._messageProps == null ? null : this._messageProps.getMessageId();
        return id == null ? null : String.valueOf(id);
    }

    public String getMimeType() {
        return this._messageProps == null ? null : this._messageProps.getContentType();
    }

    public String getEncoding() {
        return this._messageProps == null ? null : this._messageProps.getContentEncoding();
    }

    public byte getPriority() {
        MessageDeliveryPriority priority = this._deliveryProps == null || !this._deliveryProps.hasPriority() ? MessageDeliveryPriority.MEDIUM : this._deliveryProps.getPriority();
        return (byte)priority.getValue();
    }

    public long getTimestamp() {
        return this._deliveryProps == null ? 0L : this._deliveryProps.getTimestamp();
    }

    public String getType() {
        Object type = this.getHeader(JMS_TYPE);
        return type instanceof String ? (String)type : null;
    }

    public String getReplyTo() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().toString();
        }
        return null;
    }

    public String getReplyToExchange() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().getExchange();
        }
        return null;
    }

    public String getReplyToRoutingKey() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().getRoutingKey();
        }
        return null;
    }

    public Object getHeader(String name) {
        Map appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders == null ? null : appHeaders.get(name);
    }

    public boolean containsHeaders(Set<String> names) {
        Map appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null && appHeaders.keySet().containsAll(names);
    }

    public Collection<String> getHeaderNames() {
        Map appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null ? Collections.unmodifiableCollection(appHeaders.keySet()) : Collections.EMPTY_SET;
    }

    public boolean containsHeader(String name) {
        Map appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null && appHeaders.containsKey(name);
    }
}

