/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.ByteBuffer;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.TransferMessageReference;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransferMessage
extends AbstractServerMessageImpl<MessageMetaData_0_10>
implements InboundMessage {
    private Object _connectionRef;

    public MessageTransferMessage(StoredMessage<MessageMetaData_0_10> storeMessage, Object connectionRef) {
        super(storeMessage);
        this._connectionRef = connectionRef;
    }

    private MessageMetaData_0_10 getMetaData() {
        return (MessageMetaData_0_10)this.getStoredMessage().getMetaData();
    }

    public String getRoutingKey() {
        return this.getMetaData().getRoutingKey();
    }

    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this.getRoutingKey());
    }

    public AMQMessageHeader getMessageHeader() {
        return this.getMetaData().getMessageHeader();
    }

    public boolean isPersistent() {
        return this.getMetaData().isPersistent();
    }

    public boolean isRedelivered() {
        return false;
    }

    public long getSize() {
        return this.getMetaData().getSize();
    }

    public boolean isImmediate() {
        return this.getMetaData().isImmediate();
    }

    public long getExpiration() {
        return this.getMetaData().getExpiration();
    }

    public MessageReference newReference() {
        return new TransferMessageReference(this);
    }

    public long getMessageNumber() {
        return this.getStoredMessage().getMessageNumber();
    }

    public long getArrivalTime() {
        return this.getMetaData().getArrivalTime();
    }

    public int getContent(ByteBuffer buf, int offset) {
        return this.getStoredMessage().getContent(offset, buf);
    }

    public ByteBuffer getContent(int offset, int size) {
        return this.getStoredMessage().getContent(offset, size);
    }

    public Header getHeader() {
        return this.getMetaData().getHeader();
    }

    public ByteBuffer getBody() {
        return this.getContent(0, (int)this.getSize());
    }

    public Object getConnectionReference() {
        return this._connectionRef;
    }
}

