/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.v0_10.ProtocolEngine_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.network.NetworkConnection;

public class ProtocolEngineCreator_0_10
implements ProtocolEngineCreator {
    private static final byte[] AMQP_0_10_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 0, 10};
    private static ProtocolEngineCreator INSTANCE = new ProtocolEngineCreator_0_10();

    public AmqpProtocolVersion getVersion() {
        return AmqpProtocolVersion.v0_10;
    }

    public byte[] getHeaderIdentifier() {
        return AMQP_0_10_HEADER;
    }

    public ServerProtocolEngine newProtocolEngine(Broker broker, NetworkConnection network, Port port, Transport transport, long id) {
        String fqdn = null;
        SocketAddress address = network.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            fqdn = ((InetSocketAddress)address).getHostName();
        }
        ServerConnectionDelegate connDelegate = new ServerConnectionDelegate(broker, fqdn, broker.getSubjectCreator(address));
        ServerConnection conn = new ServerConnection(id, broker);
        conn.setConnectionDelegate((ConnectionDelegate)connDelegate);
        conn.setRemoteAddress(network.getRemoteAddress());
        conn.setLocalAddress(network.getLocalAddress());
        return new ProtocolEngine_0_10(conn, network, port, transport);
    }

    public static ProtocolEngineCreator getInstance() {
        return INSTANCE;
    }

    public String getType() {
        return this.getVersion().toString();
    }
}

