/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.net.SocketAddress;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.AMQException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.AMQPConnectionActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.security.AuthorizationHolder;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection
extends Connection
implements AMQConnectionModel,
LogSubject,
AuthorizationHolder {
    private Runnable _onOpenTask;
    private AtomicBoolean _logClosed = new AtomicBoolean(false);
    private LogActor _actor;
    private Subject _authorizedSubject = null;
    private Principal _authorizedPrincipal = null;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private final long _connectionId;
    private final Object _reference = new Object();
    private VirtualHost _virtualHost;
    private Port _port;
    private AtomicLong _lastIoTime = new AtomicLong();
    private boolean _blocking;
    private Principal _peerPrincipal;
    private NetworkConnection _networkConnection;
    private Transport _transport;
    private volatile boolean _stopped;

    public ServerConnection(long connectionId, Broker broker) {
        this._connectionId = connectionId;
        this._actor = new AMQPConnectionActor((AMQConnectionModel)this, broker.getRootMessageLogger());
    }

    public Object getReference() {
        return this._reference;
    }

    protected void invoke(Method method) {
        super.invoke(method);
    }

    protected void setState(Connection.State state) {
        super.setState(state);
        if (state == Connection.State.OPEN) {
            if (this._onOpenTask != null) {
                this._onOpenTask.run();
            }
            this._actor.message(ConnectionMessages.OPEN((String)this.getClientId(), (String)"0-10", (String)this.getClientVersion(), (boolean)true, (boolean)true, (boolean)true));
            this.getVirtualHost().getConnectionRegistry().registerConnection((AMQConnectionModel)this);
        }
        if ((state == Connection.State.CLOSE_RCVD || state == Connection.State.CLOSED || state == Connection.State.CLOSING) && this._virtualHost != null) {
            this._virtualHost.getConnectionRegistry().deregisterConnection((AMQConnectionModel)this);
        }
        if (state == Connection.State.CLOSED) {
            this.logClosed();
        }
    }

    protected void logClosed() {
        if (this._logClosed.compareAndSet(false, true)) {
            CurrentActor.get().message((LogSubject)this, ConnectionMessages.CLOSE());
        }
    }

    public ServerConnectionDelegate getConnectionDelegate() {
        return (ServerConnectionDelegate)super.getConnectionDelegate();
    }

    public void setConnectionDelegate(ServerConnectionDelegate delegate) {
        super.setConnectionDelegate((ConnectionDelegate)delegate);
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
        this.initialiseStatistics();
    }

    public String getVirtualHostName() {
        return this._virtualHost == null ? null : this._virtualHost.getName();
    }

    public Port getPort() {
        return this._port;
    }

    public void setPort(Port port) {
        this._port = port;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public void stop() {
        this._stopped = true;
    }

    public boolean isStopped() {
        return this._stopped;
    }

    public void setTransport(Transport transport) {
        this._transport = transport;
    }

    public void onOpen(Runnable task) {
        this._onOpenTask = task;
    }

    public void closeSession(AMQSessionModel session, AMQConstant cause, String message) throws AMQException {
        ExecutionException ex = new ExecutionException();
        ExecutionErrorCode code = ExecutionErrorCode.INTERNAL_ERROR;
        try {
            code = ExecutionErrorCode.get((int)cause.getCode());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ex.setErrorCode(code);
        ex.setDescription(message);
        ((ServerSession)session).invoke((Method)ex);
        ((ServerSession)session).close(cause, message);
    }

    public LogSubject getLogSubject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(ProtocolEvent event) {
        this._lastIoTime.set(System.currentTimeMillis());
        if (event.isConnectionControl()) {
            CurrentActor.set((LogActor)this._actor);
        } else {
            ServerSession channel = (ServerSession)this.getSession(event.getChannel());
            LogActor channelActor = null;
            if (channel != null) {
                channelActor = channel.getLogActor();
            }
            CurrentActor.set((LogActor)(channelActor == null ? this._actor : channelActor));
        }
        try {
            super.received(event);
        }
        finally {
            CurrentActor.remove();
        }
    }

    public String toLogString() {
        boolean hasClientId;
        boolean hasVirtualHost = null != this.getVirtualHost();
        boolean bl = hasClientId = null != this.getClientId();
        if (hasClientId && hasVirtualHost) {
            return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this.getConnectionId(), this.getClientId(), this.getRemoteAddressString(), this.getVirtualHost().getName()) + "] ";
        }
        if (hasClientId) {
            return "[" + MessageFormat.format("con:{0}({1}@{2})", this.getConnectionId(), this.getClientId(), this.getRemoteAddressString()) + "] ";
        }
        return "[" + MessageFormat.format("con:{0}({1})", this.getConnectionId(), this.getRemoteAddressString()) + "] ";
    }

    public LogActor getLogActor() {
        return this._actor;
    }

    public void close(AMQConstant cause, String message) throws AMQException {
        this.closeSubscriptions();
        ConnectionCloseCode replyCode = ConnectionCloseCode.NORMAL;
        try {
            replyCode = ConnectionCloseCode.get((int)cause.getCode());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.close(replyCode, message, new Option[0]);
    }

    public synchronized void block() {
        if (!this._blocking) {
            this._blocking = true;
            for (AMQSessionModel ssn : this.getSessionModels()) {
                ssn.block();
            }
        }
    }

    public synchronized void unblock() {
        if (this._blocking) {
            this._blocking = false;
            for (AMQSessionModel ssn : this.getSessionModels()) {
                ssn.unblock();
            }
        }
    }

    public synchronized void registerSession(Session ssn) {
        super.registerSession(ssn);
        if (this._blocking) {
            ((ServerSession)ssn).block();
        }
    }

    public synchronized void removeSession(Session ssn) {
        super.removeSession(ssn);
    }

    public List<AMQSessionModel> getSessionModels() {
        ArrayList<AMQSessionModel> sessions = new ArrayList<AMQSessionModel>();
        for (Session ssn : this.getChannels()) {
            sessions.add((AMQSessionModel)ssn);
        }
        return sessions;
    }

    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._virtualHost.registerMessageDelivered(messageSize);
    }

    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._virtualHost.registerMessageReceived(messageSize, timestamp);
    }

    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
    }

    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getConnectionId());
        this._dataDelivered = new StatisticsCounter("data-delivered-" + this.getConnectionId());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getConnectionId());
        this._dataReceived = new StatisticsCounter("data-received-" + this.getConnectionId());
    }

    public Subject getAuthorizedSubject() {
        return this._authorizedSubject;
    }

    public void setAuthorizedSubject(Subject authorizedSubject) {
        if (authorizedSubject == null) {
            this._authorizedSubject = null;
            this._authorizedPrincipal = null;
        } else {
            this._authorizedSubject = authorizedSubject;
            this._authorizedPrincipal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)authorizedSubject);
        }
    }

    public Principal getAuthorizedPrincipal() {
        return this._authorizedPrincipal;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public boolean isSessionNameUnique(byte[] name) {
        return !super.hasSessionWithName(name);
    }

    public String getRemoteAddressString() {
        return String.valueOf(this.getRemoteAddress());
    }

    public String getUserName() {
        return this._authorizedPrincipal.getName();
    }

    public void closed() {
        this.closeSubscriptions();
        super.closed();
    }

    private void closeSubscriptions() {
        for (Session ssn : this.getChannels()) {
            ((ServerSession)ssn).unregisterSubscriptions();
        }
    }

    public void receivedComplete() {
        for (Session ssn : this.getChannels()) {
            ((ServerSession)ssn).receivedComplete();
        }
    }

    public void send(ProtocolEvent event) {
        this._lastIoTime.set(System.currentTimeMillis());
        super.send(event);
    }

    public long getLastIoTime() {
        return this._lastIoTime.longValue();
    }

    public String getClientId() {
        return this.getConnectionDelegate().getClientId();
    }

    public String getClientVersion() {
        return this.getConnectionDelegate().getClientVersion();
    }

    public String getPrincipalAsString() {
        return this.getAuthorizedPrincipal() == null ? null : this.getAuthorizedPrincipal().getName();
    }

    public long getSessionCountLimit() {
        return this.getChannelMax();
    }

    public Principal getPeerPrincipal() {
        return this._peerPrincipal;
    }

    public void setPeerPrincipal(Principal peerPrincipal) {
        this._peerPrincipal = peerPrincipal;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        super.setRemoteAddress(remoteAddress);
    }

    public void setLocalAddress(SocketAddress localAddress) {
        super.setLocalAddress(localAddress);
    }

    public void setNetworkConnection(NetworkConnection network) {
        this._networkConnection = network;
    }

    public NetworkConnection getNetworkConnection() {
        return this._networkConnection;
    }

    public void doHeartbeat() {
        super.doHeartBeat();
    }
}

