/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.logging.messages.SubscriptionMessages;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.v0_10.CreditCreditManager;
import org.apache.qpid.server.protocol.v0_10.ExplicitAcceptDispositionChangeListener;
import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;
import org.apache.qpid.server.protocol.v0_10.ImplicitAcceptDispositionChangeListener;
import org.apache.qpid.server.protocol.v0_10.MessageAcceptCompletionListener;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.WindowCreditManager;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.queue.InboundMessageAdapter;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageCreditUnit;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Struct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription_0_10
implements Subscription,
FlowCreditManager.FlowCreditManagerListener,
LogSubject {
    private final long _subscriptionID;
    private final QueueEntry.SubscriptionAcquiredState _owningState = new QueueEntry.SubscriptionAcquiredState((Subscription)this);
    private static final Option[] BATCHED = new Option[]{Option.BATCH};
    private final Lock _stateChangeLock = new ReentrantLock();
    private final AtomicReference<Subscription.State> _state = new AtomicReference<Subscription.State>(Subscription.State.ACTIVE);
    private volatile AMQQueue.Context _queueContext;
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private FlowCreditManager_0_10 _creditManager;
    private Subscription.StateListener _stateListener = new Subscription.StateListener(){

        public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
            CurrentActor.get().message(SubscriptionMessages.STATE((String)newState.toString()));
        }
    };
    private AMQQueue _queue;
    private final String _destination;
    private boolean _noLocal;
    private final FilterManager _filters;
    private final MessageAcceptMode _acceptMode;
    private final MessageAcquireMode _acquireMode;
    private MessageFlowMode _flowMode;
    private final ServerSession _session;
    private final AtomicBoolean _stopped = new AtomicBoolean(true);
    private static final Struct[] EMPTY_STRUCT_ARRAY = new Struct[0];
    private LogActor _logActor;
    private final Map<String, Object> _properties = new ConcurrentHashMap<String, Object>();
    private String _traceExclude;
    private String _trace;
    private final long _createTime = System.currentTimeMillis();
    private final AtomicLong _deliveredCount = new AtomicLong(0L);
    private final AtomicLong _deliveredBytes = new AtomicLong(0L);
    private final AtomicLong _unacknowledgedCount = new AtomicLong(0L);
    private final AtomicLong _unacknowledgedBytes = new AtomicLong(0L);
    private final Map<String, Object> _arguments;
    private int _deferredMessageCredit;
    private long _deferredSizeCredit;
    private final AddMessageDispositionListenerAction _postIdSettingAction;

    public Subscription_0_10(ServerSession session, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, MessageFlowMode flowMode, FlowCreditManager_0_10 creditManager, FilterManager filters, Map<String, Object> arguments) {
        this._subscriptionID = SUB_ID_GENERATOR.getAndIncrement();
        this._session = session;
        this._postIdSettingAction = new AddMessageDispositionListenerAction(session);
        this._destination = destination;
        this._acceptMode = acceptMode;
        this._acquireMode = acquireMode;
        this._creditManager = creditManager;
        this._flowMode = flowMode;
        this._filters = filters;
        this._creditManager.addStateListener(this);
        this._arguments = arguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(arguments);
        this._state.set(this._creditManager.hasCredit() ? Subscription.State.ACTIVE : Subscription.State.SUSPENDED);
    }

    public void setNoLocal(boolean noLocal) {
        this._noLocal = noLocal;
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public QueueEntry.SubscriptionAcquiredState getOwningState() {
        return this._owningState;
    }

    public void setQueue(AMQQueue queue, boolean exclusive) {
        if (this.getQueue() != null) {
            throw new IllegalStateException("Attempt to set queue for subscription " + this + " to " + queue + "when already set to " + this.getQueue());
        }
        this._queue = queue;
        Map arguments = queue.getArguments();
        this._traceExclude = (String)arguments.get("qpid.trace.exclude");
        this._trace = (String)arguments.get("qpid.trace.id");
        String filterLogString = null;
        this._logActor = GenericActor.getInstance((LogSubject)this);
        if (CurrentActor.get().getRootMessageLogger().isMessageEnabled(this._logActor, (LogSubject)this, "qpid.message.subscription.create")) {
            filterLogString = this.getFilterLogString();
            CurrentActor.get().message((LogSubject)this, SubscriptionMessages.CREATE((String)filterLogString, (queue.isDurable() && exclusive ? 1 : 0) != 0, (filterLogString.length() > 0 ? 1 : 0) != 0));
        }
    }

    public String getConsumerName() {
        return this._destination;
    }

    public boolean isSuspended() {
        return !this.isActive() || this._deleted.get() || this._session.isClosing() || this._session.getConnectionModel().isStopped();
    }

    public boolean hasInterest(QueueEntry entry) {
        Object connectionRef;
        if (entry.isRejectedBy(this.getSubscriptionID())) {
            return false;
        }
        if (entry.getMessage() instanceof MessageTransferMessage ? this._noLocal && (connectionRef = ((MessageTransferMessage)entry.getMessage()).getConnectionReference()) != null && connectionRef == this._session.getReference() : MessageConverterRegistry.getConverter(entry.getMessage().getClass(), MessageTransferMessage.class) == null) {
            return false;
        }
        return this.checkFilters(entry);
    }

    private boolean checkFilters(QueueEntry entry) {
        return this._filters == null || this._filters.allAllow((Filterable)entry);
    }

    public boolean isClosed() {
        return this.getState() == Subscription.State.CLOSED;
    }

    public boolean isBrowser() {
        return this._acquireMode == MessageAcquireMode.NOT_ACQUIRED;
    }

    public boolean seesRequeues() {
        return this._acquireMode != MessageAcquireMode.NOT_ACQUIRED || this._acceptMode == MessageAcceptMode.EXPLICIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean closed = false;
        Subscription.State state = this.getState();
        this._stateChangeLock.lock();
        try {
            while (!closed && state != Subscription.State.CLOSED) {
                closed = this._state.compareAndSet(state, Subscription.State.CLOSED);
                if (!closed) {
                    state = this.getState();
                    continue;
                }
                this._stateListener.stateChange((Subscription)this, state, Subscription.State.CLOSED);
            }
            this._creditManager.removeListener(this);
            CurrentActor.get().message(this.getLogSubject(), SubscriptionMessages.CLOSE());
        }
        finally {
            this._stateChangeLock.unlock();
        }
    }

    public Long getDelivered() {
        return this._deliveredCount.get();
    }

    public void creditStateChanged(boolean hasCredit) {
        if (hasCredit) {
            if (this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
                this._stateListener.stateChange((Subscription)this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
            } else {
                this._stateListener.stateChange((Subscription)this, Subscription.State.ACTIVE, Subscription.State.ACTIVE);
            }
        } else if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange((Subscription)this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
    }

    public void send(final QueueEntry entry, boolean batch) throws AMQException {
        MessageTransferMessage msg;
        ServerMessage serverMsg = entry.getMessage();
        MessageProperties messageProps = null;
        if (serverMsg instanceof MessageTransferMessage) {
            msg = (MessageTransferMessage)serverMsg;
        } else {
            MessageConverter converter = MessageConverterRegistry.getConverter(serverMsg.getClass(), MessageTransferMessage.class);
            msg = (MessageTransferMessage)converter.convert(serverMsg, this.getQueue().getVirtualHost());
        }
        DeliveryProperties origDeliveryProps = msg.getHeader() == null ? null : msg.getHeader().getDeliveryProperties();
        messageProps = msg.getHeader() == null ? null : msg.getHeader().getMessageProperties();
        DeliveryProperties deliveryProps = new DeliveryProperties();
        if (origDeliveryProps != null) {
            if (origDeliveryProps.hasDeliveryMode()) {
                deliveryProps.setDeliveryMode(origDeliveryProps.getDeliveryMode());
            }
            if (origDeliveryProps.hasExchange()) {
                deliveryProps.setExchange(origDeliveryProps.getExchange());
            }
            if (origDeliveryProps.hasExpiration()) {
                deliveryProps.setExpiration(origDeliveryProps.getExpiration());
            }
            if (origDeliveryProps.hasPriority()) {
                deliveryProps.setPriority(origDeliveryProps.getPriority());
            }
            if (origDeliveryProps.hasRoutingKey()) {
                deliveryProps.setRoutingKey(origDeliveryProps.getRoutingKey());
            }
            if (origDeliveryProps.hasTimestamp()) {
                deliveryProps.setTimestamp(origDeliveryProps.getTimestamp());
            }
            if (origDeliveryProps.hasTtl()) {
                deliveryProps.setTtl(origDeliveryProps.getTtl());
            }
        }
        deliveryProps.setRedelivered(entry.isRedelivered());
        if (this._trace != null && messageProps == null) {
            messageProps = new MessageProperties();
        }
        Header header = new Header(deliveryProps, messageProps, msg.getHeader() == null ? null : msg.getHeader().getNonStandardProperties());
        MessageTransfer xfr = batch ? new MessageTransfer(this._destination, this._acceptMode, this._acquireMode, header, msg.getBody(), BATCHED) : new MessageTransfer(this._destination, this._acceptMode, this._acquireMode, header, msg.getBody(), new Option[0]);
        boolean excludeDueToFederation = false;
        if (this._trace != null) {
            Map appHeaders;
            String trace;
            if (!messageProps.hasApplicationHeaders()) {
                messageProps.setApplicationHeaders(new HashMap());
            }
            if ((trace = (String)(appHeaders = messageProps.getApplicationHeaders()).get("x-qpid.trace")) == null) {
                trace = this._trace;
            } else {
                if (this._traceExclude != null) {
                    excludeDueToFederation = Arrays.asList(trace.split(",")).contains(this._traceExclude);
                }
                trace = trace + "," + this._trace;
            }
            appHeaders.put("x-qpid.trace", trace);
        }
        if (!excludeDueToFederation) {
            if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode != MessageAcquireMode.PRE_ACQUIRED) {
                xfr.setCompletionListener((Method.CompletionListener)new MessageAcceptCompletionListener(this, this._session, entry, this._flowMode == MessageFlowMode.WINDOW));
            } else if (this._flowMode == MessageFlowMode.WINDOW) {
                xfr.setCompletionListener(new Method.CompletionListener(){

                    public void onComplete(Method method) {
                        Subscription_0_10.this.deferredAddCredit(1, entry.getSize());
                    }
                });
            }
            this._postIdSettingAction.setXfr(xfr);
            if (this._acceptMode == MessageAcceptMode.EXPLICIT) {
                this._postIdSettingAction.setAction(new ExplicitAcceptDispositionChangeListener(entry, this));
            } else if (this._acquireMode != MessageAcquireMode.PRE_ACQUIRED) {
                this._postIdSettingAction.setAction(new ImplicitAcceptDispositionChangeListener(entry, this));
            } else {
                this._postIdSettingAction.setAction(null);
            }
            this._session.sendMessage(xfr, this._postIdSettingAction);
            entry.incrementDeliveryCount();
            this._deliveredCount.incrementAndGet();
            this._deliveredBytes.addAndGet(entry.getSize());
            if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
                this.forceDequeue(entry, false);
            } else if (this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
                this.recordUnacknowledged(entry);
            }
        } else {
            this.forceDequeue(entry, this._flowMode == MessageFlowMode.WINDOW);
        }
    }

    void recordUnacknowledged(QueueEntry entry) {
        this._unacknowledgedCount.incrementAndGet();
        this._unacknowledgedBytes.addAndGet(entry.getSize());
    }

    private void deferredAddCredit(int deferredMessageCredit, long deferredSizeCredit) {
        this._deferredMessageCredit += deferredMessageCredit;
        this._deferredSizeCredit += deferredSizeCredit;
    }

    public void flushCreditState(boolean strict) {
        if (strict || !this.isSuspended() || this._deferredMessageCredit >= 200 || !(this._creditManager instanceof WindowCreditManager) || ((WindowCreditManager)this._creditManager).getMessageCreditLimit() < 400L) {
            this._creditManager.restoreCredit(this._deferredMessageCredit, this._deferredSizeCredit);
            this._deferredMessageCredit = 0;
            this._deferredSizeCredit = 0L;
        }
    }

    private void forceDequeue(final QueueEntry entry, final boolean restoreCredit) {
        AutoCommitTransaction dequeueTxn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getMessageStore());
        dequeueTxn.dequeue((BaseQueue)entry.getQueue(), (EnqueableMessage)entry.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                if (restoreCredit) {
                    Subscription_0_10.this.restoreCredit(entry);
                }
                entry.discard();
            }

            public void onRollback() {
            }
        });
    }

    void reject(QueueEntry entry) {
        entry.setRedelivered();
        entry.routeToAlternate();
        if (entry.isAcquiredBy((Subscription)this)) {
            entry.discard();
        }
    }

    void release(QueueEntry entry, boolean setRedelivered) {
        if (setRedelivered) {
            entry.setRedelivered();
        }
        if (this.getSessionModel().isClosing() || !setRedelivered) {
            entry.decrementDeliveryCount();
        }
        if (this.isMaxDeliveryLimitReached(entry)) {
            this.sendToDLQOrDiscard(entry);
        } else {
            entry.release();
        }
    }

    protected void sendToDLQOrDiscard(QueueEntry entry) {
        Exchange alternateExchange = entry.getQueue().getAlternateExchange();
        LogActor logActor = CurrentActor.get();
        ServerMessage msg = entry.getMessage();
        if (alternateExchange != null) {
            InboundMessageAdapter m = new InboundMessageAdapter(entry);
            List destinationQueues = alternateExchange.route((InboundMessage)m);
            if (destinationQueues == null || destinationQueues.isEmpty()) {
                entry.discard();
                logActor.message(ChannelMessages.DISCARDMSG_NOROUTE((Number)msg.getMessageNumber(), (String)alternateExchange.getName()));
            } else {
                entry.routeToAlternate();
                for (BaseQueue destinationQueue : destinationQueues) {
                    logActor.message(ChannelMessages.DEADLETTERMSG((Number)msg.getMessageNumber(), (String)destinationQueue.getNameShortString().asString()));
                }
            }
        } else {
            entry.discard();
            logActor.message(ChannelMessages.DISCARDMSG_NOALTEXCH((Number)msg.getMessageNumber(), (String)entry.getQueue().getName(), (String)msg.getRoutingKey()));
        }
    }

    private boolean isMaxDeliveryLimitReached(QueueEntry entry) {
        int maxDeliveryLimit = entry.getQueue().getMaximumDeliveryCount();
        return maxDeliveryLimit > 0 && entry.getDeliveryCount() >= maxDeliveryLimit;
    }

    public void queueDeleted(AMQQueue queue) {
        this._deleted.set(true);
    }

    public boolean wouldSuspend(QueueEntry entry) {
        return !this._creditManager.useCreditForMessage(entry.getMessage().getSize());
    }

    public boolean trySendLock() {
        return this._stateChangeLock.tryLock();
    }

    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    public void restoreCredit(QueueEntry queueEntry) {
        this._creditManager.restoreCredit(1L, queueEntry.getSize());
    }

    public void onDequeue(QueueEntry queueEntry) {
    }

    public void releaseQueueEntry(QueueEntry queueEntry) {
    }

    public void setStateListener(Subscription.StateListener listener) {
        this._stateListener = listener;
    }

    public Subscription.State getState() {
        return this._state.get();
    }

    public AMQQueue.Context getQueueContext() {
        return this._queueContext;
    }

    public void setQueueContext(AMQQueue.Context queueContext) {
        this._queueContext = queueContext;
    }

    public boolean isActive() {
        return this.getState() == Subscription.State.ACTIVE;
    }

    public void set(String key, Object value) {
        this._properties.put(key, value);
    }

    public Object get(String key) {
        return this._properties.get(key);
    }

    public FlowCreditManager_0_10 getCreditManager() {
        return this._creditManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.getSendLock();
            if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
                this._stateListener.stateChange((Subscription)this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
            }
            this._stopped.set(true);
            FlowCreditManager_0_10 creditManager = this.getCreditManager();
            creditManager.clearCredit();
        }
        finally {
            this.releaseSendLock();
        }
    }

    public void addCredit(MessageCreditUnit unit, long value) {
        FlowCreditManager_0_10 creditManager = this.getCreditManager();
        switch (unit) {
            case MESSAGE: {
                creditManager.addCredit(value, 0L);
                break;
            }
            case BYTE: {
                creditManager.addCredit(0L, value);
            }
        }
        this._stopped.set(false);
        if (creditManager.hasCredit() && this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
            this._stateListener.stateChange((Subscription)this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
        }
    }

    public void setFlowMode(MessageFlowMode flowMode) {
        this._creditManager.removeListener(this);
        switch (flowMode) {
            case CREDIT: {
                this._creditManager = new CreditCreditManager(0L, 0L);
                break;
            }
            case WINDOW: {
                this._creditManager = new WindowCreditManager(0L, 0L);
                break;
            }
            default: {
                throw new RuntimeException("Unknown message flow mode: " + flowMode);
            }
        }
        this._flowMode = flowMode;
        if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange((Subscription)this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
        this._creditManager.addStateListener(this);
    }

    public boolean isStopped() {
        return this._stopped.get();
    }

    public boolean acquires() {
        return this._acquireMode == MessageAcquireMode.PRE_ACQUIRED;
    }

    public void acknowledge(QueueEntry entry) {
        if (entry.isAcquiredBy((Subscription)this)) {
            this._unacknowledgedBytes.addAndGet(-entry.getSize());
            this._unacknowledgedCount.decrementAndGet();
            entry.discard();
        }
    }

    public void flush() throws AMQException {
        this.flushCreditState(true);
        this._queue.flushSubscription((Subscription)this);
        this.stop();
    }

    public long getSubscriptionID() {
        return this._subscriptionID;
    }

    public LogActor getLogActor() {
        return this._logActor;
    }

    public boolean isTransient() {
        return false;
    }

    public ServerSession getSessionModel() {
        return this._session;
    }

    public boolean isBrowsing() {
        return this._acquireMode == MessageAcquireMode.NOT_ACQUIRED;
    }

    public boolean isExclusive() {
        return this.getQueue().hasExclusiveSubscriber();
    }

    public boolean isDurable() {
        return false;
    }

    public boolean isExplicitAcknowledge() {
        return this._acceptMode == MessageAcceptMode.EXPLICIT;
    }

    public String getCreditMode() {
        return this._flowMode.toString();
    }

    public String getName() {
        return this._destination;
    }

    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    public boolean isSessionTransactional() {
        return this._session.isTransactional();
    }

    public void queueEmpty() {
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public String toLogString() {
        String queueInfo = MessageFormat.format("vh(/{0})/qu({1})", this._queue.getVirtualHost().getName(), this._queue.getNameShortString());
        String result = "[" + MessageFormat.format("sub:{0}", this.getSubscriptionID()) + "(" + queueInfo.substring(0, queueInfo.length() - 1) + ")" + "] ";
        return result;
    }

    private String getFilterLogString() {
        StringBuilder filterLogString = new StringBuilder();
        String delimiter = ", ";
        boolean hasEntries = false;
        if (this._filters != null && this._filters.hasFilters()) {
            filterLogString.append(this._filters.toString());
            hasEntries = true;
        }
        if (this.isBrowser()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Browser");
            hasEntries = true;
        }
        if (this.isDurable()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Durable");
            hasEntries = true;
        }
        return filterLogString.toString();
    }

    public LogSubject getLogSubject() {
        return this;
    }

    public void flushBatched() {
        this._session.getConnection().flush();
    }

    public long getBytesOut() {
        return this._deliveredBytes.longValue();
    }

    public long getMessagesOut() {
        return this._deliveredCount.longValue();
    }

    public long getUnacknowledgedBytes() {
        return this._unacknowledgedBytes.longValue();
    }

    public long getUnacknowledgedMessages() {
        return this._unacknowledgedCount.longValue();
    }

    public static class AddMessageDispositionListenerAction
    implements Runnable {
        private MessageTransfer _xfr;
        private ServerSession.MessageDispositionChangeListener _action;
        private ServerSession _session;

        public AddMessageDispositionListenerAction(ServerSession session) {
            this._session = session;
        }

        public void setXfr(MessageTransfer xfr) {
            this._xfr = xfr;
        }

        public void setAction(ServerSession.MessageDispositionChangeListener action) {
            this._action = action;
        }

        public void run() {
            if (this._action != null) {
                this._session.onMessageDispositionChange(this._xfr, this._action);
            }
        }
    }
}

