/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageConverter_v0_10;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;

@PluggableService
public class MessageConverter_Internal_to_v0_10
implements MessageConverter<InternalMessage, MessageTransferMessage> {
    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final InternalMessage serverMsg) {
        final byte[] messageContent = MessageConverter_v0_10.convertToBody(serverMsg.getMessageBody());
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg, MessageConverter_v0_10.getBodyMimeType(serverMsg.getMessageBody(), serverMsg.getMessageHeader()), messageContent.length);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return Collections.singleton(QpidByteBuffer.wrap((byte[])messageContent, (int)offset, (int)length));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(InternalMessage serverMsg, String bodyMimeType, int size) {
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)serverMsg.getMessageHeader().getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getInitialRoutingAddress());
        deliveryProps.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        messageProps.setContentEncoding(serverMsg.getMessageHeader().getEncoding());
        messageProps.setContentLength((long)size);
        messageProps.setContentType(bodyMimeType);
        if (serverMsg.getMessageHeader().getCorrelationId() != null) {
            messageProps.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId().getBytes());
        }
        messageProps.setApplicationHeaders(serverMsg.getMessageHeader().getHeaderMap());
        String messageIdAsString = serverMsg.getMessageHeader().getMessageId();
        if (messageIdAsString != null) {
            try {
                if (messageIdAsString.startsWith("ID:")) {
                    messageIdAsString = messageIdAsString.substring(3);
                }
                messageProps.setMessageId(UUID.fromString(messageIdAsString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "Internal to v0-10";
    }
}

