/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.codec.BBEncoder;

@PluggableService
public class MessageConverter_v0_10
implements MessageConverter<ServerMessage, MessageTransferMessage> {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public Class<ServerMessage> getInputClass() {
        return ServerMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(ServerMessage serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final ServerMessage<?> serverMsg) {
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return serverMsg.getContent(offset, length);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(ServerMessage serverMsg) {
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        int size = (int)serverMsg.getSize();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)serverMsg.getMessageHeader().getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getInitialRoutingAddress());
        deliveryProps.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        messageProps.setContentEncoding(serverMsg.getMessageHeader().getEncoding());
        messageProps.setContentLength((long)size);
        messageProps.setContentType(serverMsg.getMessageHeader().getMimeType());
        if (serverMsg.getMessageHeader().getCorrelationId() != null) {
            messageProps.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId().getBytes());
        }
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public static byte[] convertToBody(Object object) {
        if (object instanceof String) {
            return ((String)object).getBytes(UTF_8);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Map) {
            BBEncoder encoder = new BBEncoder(1024);
            encoder.writeMap((Map)object);
            ByteBuffer buf = encoder.segment();
            int remaining = buf.remaining();
            byte[] data = new byte[remaining];
            buf.get(data);
            return data;
        }
        if (object instanceof List) {
            BBEncoder encoder = new BBEncoder(1024);
            encoder.writeList((List)object);
            ByteBuffer buf = encoder.segment();
            int remaining = buf.remaining();
            byte[] data = new byte[remaining];
            buf.get(data);
            return data;
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bytesOut);
            os.writeObject(object);
            return bytesOut.toByteArray();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    public static String getBodyMimeType(Object object, InternalMessageHeader header) {
        if (object instanceof String) {
            String mimeType;
            if (header == null || (mimeType = header.getMimeType()) == null || !mimeType.trim().startsWith("text/")) {
                return "text/plain";
            }
            return mimeType;
        }
        if (object instanceof byte[]) {
            String mimeType;
            if (header == null || (mimeType = header.getMimeType()) == null || "".equals(mimeType.trim())) {
                return "application/octet-stream";
            }
            return mimeType;
        }
        if (object instanceof Map) {
            return "amqp/map";
        }
        if (object instanceof List) {
            return "amqp/list";
        }
        return "application/java-object-stream";
    }

    public String getType() {
        return "Unknown to v0-10";
    }
}

