/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerDecoder;
import org.apache.qpid.server.protocol.v0_10.ServerFrame;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAssembler.class);
    private final ServerConnection _connection;
    private static final int ARRAY_SIZE = 255;
    private final Method[] _incompleteMethodArray = new Method[256];
    private final Map<Integer, Method> _incompleteMethodMap = new HashMap<Integer, Method>();
    private final Map<Integer, List<ServerFrame>> _segments;

    public ServerAssembler(ServerConnection connection) {
        this._connection = connection;
        this._segments = new HashMap<Integer, List<ServerFrame>>();
    }

    public void received(ServerFrame event) {
        if (!this._connection.isIgnoreFutureInput()) {
            this.frame(event);
        } else {
            LOGGER.debug("Ignored network event " + event + " as connection is ignoring further input ");
        }
    }

    protected ByteBuffer allocateByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    private int segmentKey(ServerFrame frame) {
        return (frame.getTrack() + 1) * frame.getChannel();
    }

    private List<ServerFrame> getSegment(ServerFrame frame) {
        return this._segments.get(this.segmentKey(frame));
    }

    private void setSegment(ServerFrame frame, List<ServerFrame> segment) {
        int key = this.segmentKey(frame);
        if (this._segments.containsKey(key)) {
            this.error(new ProtocolError(1, "segment in progress: %s", new Object[]{frame}));
        }
        this._segments.put(this.segmentKey(frame), segment);
    }

    private void clearSegment(ServerFrame frame) {
        this._segments.remove(this.segmentKey(frame));
    }

    private void emit(int channel, ProtocolEvent event) {
        event.setChannel(channel);
        this._connection.received(event);
    }

    public void exception(Throwable t) {
        this._connection.exception(t);
    }

    public void closed() {
        this._connection.closed();
    }

    public void init(ProtocolHeader header) {
        this.emit(0, (ProtocolEvent)header);
    }

    public void error(ProtocolError error) {
        this.emit(0, (ProtocolEvent)error);
    }

    public void frame(ServerFrame frame) {
        if (frame.isFirstFrame() && frame.isLastFrame()) {
            List<QpidByteBuffer> frameBuffers = Collections.singletonList(frame.getBody());
            this.assemble(frame, frameBuffers);
        } else {
            List<Object> frames;
            if (frame.isFirstFrame()) {
                frames = new ArrayList();
                this.setSegment(frame, frames);
            } else {
                frames = this.getSegment(frame);
            }
            frames.add(frame);
            if (frame.isLastFrame()) {
                this.clearSegment(frame);
                ArrayList<QpidByteBuffer> frameBuffers = new ArrayList<QpidByteBuffer>(frames.size());
                for (ServerFrame serverFrame : frames) {
                    frameBuffers.add(serverFrame.getBody());
                }
                this.assemble(frame, frameBuffers);
            }
        }
    }

    private void assemble(ServerFrame frame, List<QpidByteBuffer> frameBuffers) {
        ServerDecoder dec = new ServerDecoder(frameBuffers);
        int channel = frame.getChannel();
        switch (frame.getType()) {
            case CONTROL: {
                int controlType = dec.readUint16();
                Method control = Method.create((int)controlType);
                control.read((Decoder)dec);
                this.emit(channel, (ProtocolEvent)control);
                break;
            }
            case COMMAND: {
                int commandType = dec.readUint16();
                int hdr = dec.readUint16();
                Method command = Method.create((int)commandType);
                command.setSync((1 & hdr) != 0);
                command.read((Decoder)dec);
                if (command.hasPayload() && !frame.isLastSegment()) {
                    this.setIncompleteCommand(channel, command);
                    break;
                }
                this.emit(channel, (ProtocolEvent)command);
                break;
            }
            case HEADER: {
                Method command = this.getIncompleteCommand(channel);
                ArrayList<Struct> structs = null;
                DeliveryProperties deliveryProps = null;
                MessageProperties messageProps = null;
                while (dec.hasRemaining()) {
                    Struct struct = dec.readStruct32();
                    if (struct instanceof DeliveryProperties && deliveryProps == null) {
                        deliveryProps = (DeliveryProperties)struct;
                        continue;
                    }
                    if (struct instanceof MessageProperties && messageProps == null) {
                        messageProps = (MessageProperties)struct;
                        continue;
                    }
                    if (structs == null) {
                        structs = new ArrayList<Struct>(2);
                    }
                    structs.add(struct);
                }
                command.setHeader(new Header(deliveryProps, messageProps, structs));
                if (!frame.isLastSegment()) break;
                this.setIncompleteCommand(channel, null);
                this.emit(channel, (ProtocolEvent)command);
                break;
            }
            case BODY: {
                Method command = this.getIncompleteCommand(channel);
                command.setBody(frameBuffers);
                this.setIncompleteCommand(channel, null);
                this.emit(channel, (ProtocolEvent)command);
                break;
            }
            default: {
                throw new IllegalStateException("unknown frame type: " + frame.getType());
            }
        }
        for (QpidByteBuffer buf : frameBuffers) {
            buf.dispose();
        }
    }

    private void setIncompleteCommand(int channelId, Method incomplete) {
        if ((channelId & 0xFF) == channelId) {
            this._incompleteMethodArray[channelId] = incomplete;
        } else if (incomplete != null) {
            this._incompleteMethodMap.put(channelId, incomplete);
        } else {
            this._incompleteMethodMap.remove(channelId);
        }
    }

    private Method getIncompleteCommand(int channelId) {
        if ((channelId & 0xFF) == channelId) {
            return this._incompleteMethodArray[channelId];
        }
        return this._incompleteMethodMap.get(channelId);
    }
}

