/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.transport.SegmentType;
import org.apache.qpid.transport.util.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFrame.class);
    public static final int HEADER_SIZE = 12;
    public static final byte L1 = 0;
    public static final byte L2 = 1;
    public static final byte L3 = 2;
    public static final byte L4 = 3;
    public static final byte FIRST_SEG = 8;
    public static final byte LAST_SEG = 4;
    public static final byte FIRST_FRAME = 2;
    public static final byte LAST_FRAME = 1;
    private final byte flags;
    private final SegmentType type;
    private final byte track;
    private final int channel;
    private final QpidByteBuffer body;

    public ServerFrame(byte flags, SegmentType type, byte track, int channel, QpidByteBuffer body) {
        this.flags = flags;
        this.type = type;
        this.track = track;
        this.channel = channel;
        this.body = body;
    }

    public QpidByteBuffer getBody() {
        return this.body;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getSize() {
        return this.body.remaining();
    }

    public SegmentType getType() {
        return this.type;
    }

    public byte getTrack() {
        return this.track;
    }

    private boolean flag(byte mask) {
        return (this.flags & mask) != 0;
    }

    public boolean isFirstSegment() {
        return this.flag((byte)8);
    }

    public boolean isLastSegment() {
        return this.flag((byte)4);
    }

    public boolean isFirstFrame() {
        return this.flag((byte)2);
    }

    public boolean isLastFrame() {
        return this.flag((byte)1);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("[%05d %05d %1d %s %d%d%d%d] ", this.getChannel(), this.getSize(), this.getTrack(), this.getType(), this.isFirstSegment() ? 1 : 0, this.isLastSegment() ? 1 : 0, this.isFirstFrame() ? 1 : 0, this.isLastFrame() ? 1 : 0));
        str.append(Functions.str((QpidByteBuffer)this.body));
        return str.toString();
    }
}

