/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.server.transport.util.Functions;

public final class Binary {
    private byte[] bytes;
    private int offset;
    private int size;
    private int hash = 0;

    public Binary(byte[] bytes, int offset, int size) {
        if (offset + size > bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bytes = bytes;
        this.offset = offset;
        this.size = size;
    }

    public Binary(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public final byte[] getBytes() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.bytes, this.offset, result, 0, this.size);
        return result;
    }

    public final byte[] array() {
        return this.bytes;
    }

    public final int offset() {
        return this.offset;
    }

    public final int size() {
        return this.size;
    }

    public final Binary slice(int low, int high) {
        int sz = high < 0 ? this.size + high : high - low;
        if (sz < 0) {
            sz = 0;
        }
        return new Binary(this.bytes, this.offset + low, sz);
    }

    public final int hashCode() {
        if (this.hash == 0) {
            int hc = 0;
            for (int i = 0; i < this.size; ++i) {
                hc = 31 * hc + (0xFF & this.bytes[this.offset + i]);
            }
            this.hash = hc;
        }
        return this.hash;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Binary)) {
            return false;
        }
        Binary buf = (Binary)o;
        if (this.size != buf.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.bytes[this.offset + i] == buf.bytes[buf.offset + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Functions.str((ByteBuffer)ByteBuffer.wrap(this.bytes, this.offset, this.size));
    }

    public boolean hasExcessCapacity() {
        return this.size != this.bytes.length;
    }

    public Binary copy() {
        return new Binary(this.getBytes());
    }
}

