/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.ServerSessionDelegate;
import org.apache.qpid.server.protocol.v0_10.Session_0_10;
import org.apache.qpid.server.protocol.v0_10.transport.Binary;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionClose;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseCode;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionException;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionHeartbeat;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionOpen;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionOpenOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionRedirect;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionSecureOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionStartOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionTuneOk;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolError;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolHeader;
import org.apache.qpid.server.protocol.v0_10.transport.SessionAttach;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetach;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetachCode;
import org.apache.qpid.server.protocol.v0_10.transport.SessionDetached;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionDelegate
extends MethodDelegate<ServerConnection>
implements ProtocolDelegate<ServerConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConnectionDelegate.class);
    static final String MESSAGE_DIGEST_SHA1 = "SHA-1";
    static final int BASE64_LIMIT = 64;
    private final AmqpPort<?> _port;
    private List<Object> _locales;
    private List<Object> _mechanisms;
    private final Broker<?> _broker;
    private int _maxNoOfChannels;
    private Map<String, Object> _clientProperties;
    private final SubjectCreator _subjectCreator;
    private int _maximumFrameSize;
    private boolean _compressionSupported;
    private volatile SaslNegotiator _saslNegotiator;
    private volatile ConnectionState _state = ConnectionState.INIT;
    private volatile SubjectAuthenticationResult _successfulAuthenticationResult;

    public ServerConnectionDelegate(AmqpPort<?> port, boolean secure, String selectedHost) {
        this._port = port;
        this._broker = (Broker)port.getParent();
        this._mechanisms = new ArrayList<Object>(port.getAuthenticationProvider().getAvailableMechanisms(secure));
        this._maxNoOfChannels = port.getSessionCountLimit();
        this._subjectCreator = port.getSubjectCreator(secure, selectedHost);
        this._maximumFrameSize = Math.min(65535, this._broker.getNetworkBufferSize());
    }

    @Override
    public void control(ServerConnection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void command(ServerConnection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void error(ServerConnection conn, ProtocolError error) {
        conn.exception(new ConnectionException(error.getMessage()));
    }

    @Override
    public void handle(ServerConnection conn, Method method) {
        conn.dispatch(method);
    }

    @Override
    public void connectionHeartbeat(ServerConnection conn, ConnectionHeartbeat hearbeat) {
    }

    protected void sendConnectionCloseOkAndCloseSender(ServerConnection conn) {
        conn.connectionCloseOk(new Option[0]);
        conn.getSender().close();
    }

    @Override
    public void connectionCloseOk(ServerConnection conn, ConnectionCloseOk ok) {
        conn.getSender().close();
    }

    @Override
    public void sessionDetached(ServerConnection conn, SessionDetached dtc) {
        ServerSession ssn = conn.getSession(dtc.getChannel());
        if (ssn != null) {
            ssn.setDetachCode(dtc.getCode());
            conn.unmap(ssn);
            ssn.closed();
        }
    }

    public final ConnectionState getState() {
        return this._state;
    }

    private void assertState(ServerConnection conn, ConnectionState requiredState) {
        if (this._state != requiredState) {
            String replyText = "Command Invalid, expected " + (Object)((Object)requiredState) + " but was " + (Object)((Object)this._state);
            conn.sendConnectionClose(ConnectionCloseCode.FRAMING_ERROR, replyText, new Option[0]);
            conn.closeAndIgnoreFutureInput();
            throw new ConnectionScopedRuntimeException(replyText);
        }
    }

    @Override
    public void init(ServerConnection serverConnection, ProtocolHeader hdr) {
        this.assertState(serverConnection, ConnectionState.INIT);
        serverConnection.send(new ProtocolHeader(1, 0, 10));
        Map props = Collections.emptyMap();
        for (ConnectionPropertyEnricher enricher : this._port.getConnectionPropertyEnrichers()) {
            props = enricher.addConnectionProperties((AMQPConnection)serverConnection.getAmqpConnection(), props);
        }
        serverConnection.sendConnectionStart(props, this._mechanisms, Collections.singletonList("en_US"), new Option[0]);
        this._state = ConnectionState.AWAIT_START_OK;
    }

    @Override
    public void connectionSecureOk(ServerConnection serverConnection, ConnectionSecureOk ok) {
        this.assertState(serverConnection, ConnectionState.AWAIT_SECURE_OK);
        this.secure(serverConnection, ok.getResponse());
    }

    protected void secure(ServerConnection sconn, byte[] response) {
        SubjectAuthenticationResult authResult = this._successfulAuthenticationResult;
        byte[] challenge = null;
        if (authResult == null) {
            authResult = this._subjectCreator.authenticate(this._saslNegotiator, response);
            challenge = authResult.getChallenge();
        }
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)authResult.getStatus())) {
            this._successfulAuthenticationResult = authResult;
            if (challenge == null || challenge.length == 0) {
                sconn.sendConnectionTune(this.getChannelMax(), this.getFrameMax(), 0, this.getHeartbeatMax(), new Option[0]);
                sconn.setAuthorizedSubject(authResult.getSubject());
                this._state = ConnectionState.AWAIT_TUNE_OK;
                this.disposeSaslNegotiator();
            } else {
                sconn.sendConnectionSecure(authResult.getChallenge(), new Option[0]);
                this._state = ConnectionState.AWAIT_SECURE_OK;
            }
        } else if (AuthenticationResult.AuthenticationStatus.CONTINUE.equals((Object)authResult.getStatus())) {
            sconn.sendConnectionSecure(authResult.getChallenge(), new Option[0]);
            this._state = ConnectionState.AWAIT_SECURE_OK;
        } else {
            this.connectionAuthFailed(sconn, authResult.getCause());
        }
    }

    @Override
    public void connectionClose(ServerConnection sconn, ConnectionClose close) {
        sconn.closeCode(close);
        sconn.setState(ServerConnection.State.CLOSE_RCVD);
        this.sendConnectionCloseOkAndCloseSender(sconn);
    }

    @Override
    public void connectionOpen(ServerConnection sconn, ConnectionOpen open) {
        this.assertState(sconn, ConnectionState.AWAIT_OPEN);
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        AmqpPort<?> port = sconn.getPort();
        NamedAddressSpace addressSpace = port.getAddressSpace(vhostName);
        if (addressSpace != null) {
            if (!addressSpace.isActive()) {
                sconn.setState(ServerConnection.State.CLOSING);
                String redirectHost = addressSpace.getRedirectHost(port);
                if (redirectHost == null) {
                    sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Virtual host '" + vhostName + "' is not active", new Option[0]);
                } else {
                    sconn.invoke(new ConnectionRedirect(redirectHost, new ArrayList<Object>(), new Option[0]));
                }
                return;
            }
            try {
                sconn.setVirtualHost(addressSpace);
                if (!addressSpace.authoriseCreateConnection((AMQPConnection)sconn.getAmqpConnection())) {
                    sconn.setState(ServerConnection.State.CLOSING);
                    sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Connection not authorized", new Option[0]);
                    return;
                }
            }
            catch (AccessControlException | VirtualHostUnavailableException e) {
                sconn.setState(ServerConnection.State.CLOSING);
                sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, e.getMessage(), new Option[0]);
                return;
            }
            sconn.setState(ServerConnection.State.OPEN);
            this._state = ConnectionState.OPEN;
            sconn.invoke(new ConnectionOpenOk(Collections.emptyList(), new Option[0]));
        } else {
            sconn.setState(ServerConnection.State.CLOSING);
            sconn.sendConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]);
        }
    }

    @Override
    public void connectionTuneOk(ServerConnection sconn, ConnectionTuneOk ok) {
        this.assertState(sconn, ConnectionState.AWAIT_TUNE_OK);
        int okChannelMax = ok.getChannelMax();
        int okMaxFrameSize = ok.getMaxFrameSize();
        if (okChannelMax > this.getChannelMax()) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, client connectionTuneOk returned a channelMax (" + okChannelMax + ") above the server's offered limit (" + this.getChannelMax() + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize > this.getFrameMax()) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, client connectionTuneOk returned a frameMax (" + okMaxFrameSize + ") above the server's offered limit (" + this.getFrameMax() + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize > 0 && okMaxFrameSize < 4096) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, client connectionTuneOk returned a frameMax (" + okMaxFrameSize + ") below the minimum permitted size (" + 4096 + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize == 0) {
            okMaxFrameSize = this.getFrameMax();
        }
        if (ok.hasHeartbeat() && ok.getHeartbeat() > 0) {
            int heartbeat = ok.getHeartbeat();
            sconn.setHeartBeatDelay(heartbeat);
            long readerIdle = 2000L * (long)heartbeat;
            long writerIdle = 1000L * (long)heartbeat;
            sconn.getAmqpConnection().initialiseHeartbeating(writerIdle, readerIdle);
        }
        sconn.setChannelMax(okChannelMax == 0 ? this.getChannelMax() : okChannelMax);
        sconn.setMaxFrameSize(okMaxFrameSize);
        this._state = ConnectionState.AWAIT_OPEN;
    }

    private int getChannelMax() {
        return this._maxNoOfChannels;
    }

    private int getFrameMax() {
        return this._maximumFrameSize;
    }

    @Override
    public void sessionDetach(ServerConnection conn, SessionDetach dtc) {
        int channel = dtc.getChannel();
        ServerSession ssn = conn.getSession(channel);
        if (ssn != null) {
            this.stopAllSubscriptions(ssn);
            ssn.setClose(true);
            ssn.sessionDetached(dtc.getName(), ssn.getDetachCode() == null ? SessionDetachCode.NORMAL : ssn.getDetachCode(), new Option[0]);
            conn.unmap(ssn);
            ssn.closed();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SessionDetach received on unattached channel : {}", (Object)channel);
            }
            SessionDetached sessionDetached = new SessionDetached(dtc.getName(), SessionDetachCode.NOT_ATTACHED, new Option[0]);
            sessionDetached.setChannel(channel);
            conn.invoke(sessionDetached);
        }
    }

    private void stopAllSubscriptions(ServerSession ssn) {
        Collection<ConsumerTarget_0_10> subs = ssn.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subs) {
            subscription_0_10.stop();
        }
    }

    @Override
    public void sessionAttach(ServerConnection serverConnection, SessionAttach atc) {
        this.assertState(serverConnection, ConnectionState.OPEN);
        if (this.isSessionNameUnique(atc.getName(), serverConnection)) {
            ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate();
            ServerSession serverSession = new ServerSession(serverConnection, serverSessionDelegate, new Binary(atc.getName()), 0L);
            Session_0_10 session = new Session_0_10((Connection<?>)serverConnection.getAmqpConnection(), atc.getChannel(), serverSession, this.getPeerSessionName(atc.getName()));
            session.create();
            serverSession.setModelObject(session);
            serverConnection.map(serverSession, atc.getChannel());
            serverConnection.registerSession(serverSession);
            serverSession.sendSessionAttached(atc.getName(), new Option[0]);
            serverSession.setState(ServerSession.State.OPEN);
        } else {
            SessionDetached detached = new SessionDetached(atc.getName(), SessionDetachCode.SESSION_BUSY, new Option[0]);
            detached.setChannel(atc.getChannel());
            serverConnection.invoke(detached);
        }
    }

    private String getPeerSessionName(byte[] attachName) {
        try {
            return UUID.fromString(new String(attachName, StandardCharsets.UTF_8)).toString();
        }
        catch (RuntimeException e) {
            return this.createBase64OrSha1(attachName);
        }
    }

    private String createBase64OrSha1(byte[] attachName) {
        if (attachName.length <= 64) {
            return Base64.getEncoder().encodeToString(attachName);
        }
        return this.createSha1(attachName);
    }

    private String createSha1(byte[] attachName) {
        try {
            MessageDigest digest = MessageDigest.getInstance(MESSAGE_DIGEST_SHA1);
            return Base64.getEncoder().encodeToString(digest.digest(attachName));
        }
        catch (NoSuchAlgorithmException e) {
            return Base64.getEncoder().encodeToString(attachName);
        }
    }

    void setState(ConnectionState state) {
        this._state = state;
    }

    private boolean isSessionNameUnique(byte[] name, ServerConnection conn) {
        Principal authorizedPrincipal = conn.getAuthorizedPrincipal();
        String userId = authorizedPrincipal == null ? "" : authorizedPrincipal.getName();
        for (AMQPConnection amqConnectionModel : conn.getAddressSpace().getConnections()) {
            String userName = amqConnectionModel.getAuthorizedPrincipal() == null ? "" : amqConnectionModel.getAuthorizedPrincipal().getName();
            if (!userId.equals(userName) || !amqConnectionModel.hasSessionWithName(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void connectionStartOk(ServerConnection serverConnection, ConnectionStartOk ok) {
        this.assertState(serverConnection, ConnectionState.AWAIT_START_OK);
        this._clientProperties = ok.getClientProperties();
        if (this._clientProperties != null) {
            Object compressionSupported = this._clientProperties.get("qpid.message_compression_supported");
            if (compressionSupported != null) {
                this._compressionSupported = Boolean.parseBoolean(String.valueOf(compressionSupported));
            }
            AMQPConnection_0_10 protocolEngine = serverConnection.getAmqpConnection();
            protocolEngine.setClientId(this.getStringClientProperty("clientName"));
            protocolEngine.setClientProduct(this.getStringClientProperty("product"));
            protocolEngine.setClientVersion(this.getStringClientProperty("qpid.client_version"));
            protocolEngine.setRemoteProcessPid(this.getStringClientProperty("qpid.client_pid"));
        }
        serverConnection.setLocale(ok.getLocale());
        String mechanism = ok.getMechanism();
        if (mechanism == null || mechanism.length() == 0) {
            serverConnection.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "No Sasl mechanism was specified", new Option[0]);
            return;
        }
        this._saslNegotiator = this._subjectCreator.createSaslNegotiator(mechanism, (SaslSettings)serverConnection.getAmqpConnection());
        if (this._saslNegotiator == null) {
            serverConnection.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "No SaslServer could be created for mechanism: " + mechanism, new Option[0]);
        } else {
            this.secure(serverConnection, ok.getResponse());
        }
    }

    private String getStringClientProperty(String name) {
        return this._clientProperties == null || this._clientProperties.get(name) == null ? null : String.valueOf(this._clientProperties.get(name));
    }

    protected int getHeartbeatMax() {
        int delay = this._port.getHeartbeatDelay();
        return delay == 0 ? 65535 : delay;
    }

    public boolean isCompressionSupported() {
        return this._compressionSupported && this._broker.isMessageCompressionEnabled();
    }

    private void connectionAuthFailed(ServerConnection serverConnection, Exception e) {
        if (e != null) {
            serverConnection.exception(e);
        }
        serverConnection.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, e == null ? "Authentication failed" : e.getMessage(), new Option[0]);
        this.disposeSaslNegotiator();
    }

    private void disposeSaslNegotiator() {
        this._saslNegotiator.dispose();
        this._saslNegotiator = null;
    }

    static enum ConnectionState {
        INIT,
        AWAIT_START_OK,
        AWAIT_SECURE_OK,
        AWAIT_TUNE_OK,
        AWAIT_OPEN,
        OPEN;

    }
}

