/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.ArrayList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v0_10.MessageMetaDataType_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferHeader;
import org.apache.qpid.server.protocol.v0_10.ServerDecoder;
import org.apache.qpid.server.protocol.v0_10.ServerEncoder;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.EncoderUtils;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.MessageTransfer;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.store.StorableMessageMetaData;

public class MessageMetaData_0_10
implements StorableMessageMetaData {
    private final Header _header;
    private DeliveryProperties _deliveryProps;
    private MessageProperties _messageProps;
    private MessageTransferHeader _messageHeader;
    private int _bodySize;
    private static final int ENCODER_SIZE = 1024;
    public static final MessageMetaDataType.Factory<MessageMetaData_0_10> FACTORY = new MetaDataFactory();
    private static final MessageMetaDataType_0_10 TYPE = new MessageMetaDataType_0_10();
    private volatile QpidByteBuffer _encoded;

    public MessageMetaData_0_10(MessageTransfer xfr) {
        this(xfr.getHeader(), xfr.getBodySize(), System.currentTimeMillis());
    }

    public MessageMetaData_0_10(Header header, int bodySize, long arrivalTime) {
        this._header = header;
        if (this._header != null) {
            this._deliveryProps = this._header.getDeliveryProperties();
            this._messageProps = this._header.getMessageProperties();
        } else {
            this._deliveryProps = null;
            this._messageProps = null;
        }
        this._messageHeader = new MessageTransferHeader(this._deliveryProps, this._messageProps, arrivalTime);
        this._bodySize = bodySize;
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        int len = 0;
        len += 8;
        len += 4;
        len += 4;
        if (this._header != null) {
            if (this._header.getDeliveryProperties() != null) {
                len += EncoderUtils.getStruct32Length(this._header.getDeliveryProperties());
            }
            if (this._header.getMessageProperties() != null) {
                len += EncoderUtils.getStruct32Length(this._header.getMessageProperties());
            }
            if (this._header.getNonStandardProperties() != null) {
                for (Struct header : this._header.getNonStandardProperties()) {
                    len += EncoderUtils.getStruct32Length(header);
                }
            }
        }
        return len;
    }

    private QpidByteBuffer encodeAsBuffer() {
        ServerEncoder encoder = new ServerEncoder(1024, false);
        encoder.writeInt64(this._messageHeader.getArrivalTime());
        encoder.writeInt32(this._bodySize);
        int headersLength = 0;
        if (this._header != null) {
            if (this._header.getDeliveryProperties() != null) {
                ++headersLength;
            }
            if (this._header.getMessageProperties() != null) {
                ++headersLength;
            }
            if (this._header.getNonStandardProperties() != null) {
                headersLength += this._header.getNonStandardProperties().size();
            }
        }
        encoder.writeInt32(headersLength);
        if (this._header != null) {
            if (this._header.getDeliveryProperties() != null) {
                encoder.writeStruct32(this._header.getDeliveryProperties());
            }
            if (this._header.getMessageProperties() != null) {
                encoder.writeStruct32(this._header.getMessageProperties());
            }
            if (this._header.getNonStandardProperties() != null) {
                for (Struct header : this._header.getNonStandardProperties()) {
                    encoder.writeStruct32(header);
                }
            }
        }
        QpidByteBuffer buf = encoder.getBuffer();
        encoder.close();
        return buf;
    }

    public synchronized void writeToBuffer(QpidByteBuffer dest) {
        if (this._encoded == null) {
            this._encoded = this.encodeAsBuffer();
        }
        dest.put(this._encoded);
        this.clearEncodedForm();
    }

    public int getContentSize() {
        return this._bodySize;
    }

    public boolean isPersistent() {
        return this._deliveryProps != null && this._deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT;
    }

    public void dispose() {
        this.clearEncodedForm();
    }

    public synchronized void clearEncodedForm() {
        if (this._encoded != null) {
            this._encoded.dispose();
            this._encoded = null;
        }
    }

    public synchronized void reallocate() {
        this._encoded = QpidByteBuffer.reallocateIfNecessary((QpidByteBuffer)this._encoded);
    }

    public String getRoutingKey() {
        return this._deliveryProps == null ? null : this._deliveryProps.getRoutingKey();
    }

    public String getExchange() {
        return this._deliveryProps == null ? null : this._deliveryProps.getExchange();
    }

    public AMQMessageHeader getMessageHeader() {
        return this._messageHeader;
    }

    public long getSize() {
        return this._bodySize;
    }

    public boolean isImmediate() {
        return this._deliveryProps != null && this._deliveryProps.getImmediate();
    }

    public long getExpiration() {
        return this._messageHeader.getExpiration();
    }

    public long getArrivalTime() {
        return this._messageHeader.getArrivalTime();
    }

    public Header getHeader() {
        return this._header;
    }

    public DeliveryProperties getDeliveryProperties() {
        return this._deliveryProps;
    }

    public MessageProperties getMessageProperties() {
        return this._messageProps;
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData_0_10> {
        private MetaDataFactory() {
        }

        public MessageMetaData_0_10 createMetaData(QpidByteBuffer buf) {
            ServerDecoder decoder = new ServerDecoder(buf);
            long arrivalTime = decoder.readInt64();
            int bodySize = decoder.readInt32();
            int headerCount = decoder.readInt32();
            DeliveryProperties deliveryProperties = null;
            MessageProperties messageProperties = null;
            ArrayList<Struct> otherProps = null;
            for (int i = 0; i < headerCount; ++i) {
                Struct struct = decoder.readStruct32();
                if (struct instanceof DeliveryProperties && deliveryProperties == null) {
                    deliveryProperties = (DeliveryProperties)struct;
                    continue;
                }
                if (struct instanceof MessageProperties && messageProperties == null) {
                    messageProperties = (MessageProperties)struct;
                    continue;
                }
                if (otherProps == null) {
                    otherProps = new ArrayList<Struct>();
                }
                otherProps.add(struct);
            }
            Header header = new Header(deliveryProperties, messageProperties, otherProps);
            return new MessageMetaData_0_10(header, bodySize, arrivalTime);
        }
    }
}

