/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.ArrivalTimeFilter;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterManagerFactory;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RejectType;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.WindowCreditManager;
import org.apache.qpid.server.protocol.v0_10.transport.Acquired;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseCode;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.DtxCommit;
import org.apache.qpid.server.protocol.v0_10.transport.DtxEnd;
import org.apache.qpid.server.protocol.v0_10.transport.DtxForget;
import org.apache.qpid.server.protocol.v0_10.transport.DtxGetTimeout;
import org.apache.qpid.server.protocol.v0_10.transport.DtxPrepare;
import org.apache.qpid.server.protocol.v0_10.transport.DtxRecover;
import org.apache.qpid.server.protocol.v0_10.transport.DtxRollback;
import org.apache.qpid.server.protocol.v0_10.transport.DtxSelect;
import org.apache.qpid.server.protocol.v0_10.transport.DtxSetTimeout;
import org.apache.qpid.server.protocol.v0_10.transport.DtxStart;
import org.apache.qpid.server.protocol.v0_10.transport.DtxXaStatus;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeBind;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeBound;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeBoundResult;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeDeclare;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeDelete;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeQuery;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeQueryResult;
import org.apache.qpid.server.protocol.v0_10.transport.ExchangeUnbind;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionErrorCode;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionException;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionResult;
import org.apache.qpid.server.protocol.v0_10.transport.ExecutionSync;
import org.apache.qpid.server.protocol.v0_10.transport.GetTimeoutResult;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAccept;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcceptMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquire;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquireMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageCancel;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlow;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlowMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlush;
import org.apache.qpid.server.protocol.v0_10.transport.MessageReject;
import org.apache.qpid.server.protocol.v0_10.transport.MessageRejectCode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageRelease;
import org.apache.qpid.server.protocol.v0_10.transport.MessageResume;
import org.apache.qpid.server.protocol.v0_10.transport.MessageSetFlowMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageStop;
import org.apache.qpid.server.protocol.v0_10.transport.MessageSubscribe;
import org.apache.qpid.server.protocol.v0_10.transport.MessageTransfer;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolError;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolHeader;
import org.apache.qpid.server.protocol.v0_10.transport.QueueDeclare;
import org.apache.qpid.server.protocol.v0_10.transport.QueueDelete;
import org.apache.qpid.server.protocol.v0_10.transport.QueuePurge;
import org.apache.qpid.server.protocol.v0_10.transport.QueueQuery;
import org.apache.qpid.server.protocol.v0_10.transport.QueueQueryResult;
import org.apache.qpid.server.protocol.v0_10.transport.Range;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSet;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSetFactory;
import org.apache.qpid.server.protocol.v0_10.transport.RecoverResult;
import org.apache.qpid.server.protocol.v0_10.transport.SessionAttached;
import org.apache.qpid.server.protocol.v0_10.transport.SessionCommandPoint;
import org.apache.qpid.server.protocol.v0_10.transport.SessionCompleted;
import org.apache.qpid.server.protocol.v0_10.transport.SessionFlush;
import org.apache.qpid.server.protocol.v0_10.transport.SessionKnownCompleted;
import org.apache.qpid.server.protocol.v0_10.transport.SessionRequestTimeout;
import org.apache.qpid.server.protocol.v0_10.transport.SessionTimeout;
import org.apache.qpid.server.protocol.v0_10.transport.TxCommit;
import org.apache.qpid.server.protocol.v0_10.transport.TxRollback;
import org.apache.qpid.server.protocol.v0_10.transport.TxSelect;
import org.apache.qpid.server.protocol.v0_10.transport.XaResult;
import org.apache.qpid.server.queue.QueueArgumentsConverter;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.DtxNotSelectedException;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.MessageDestinationIsAlternateException;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.UnknownAlternateBindingException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionDelegate
extends MethodDelegate<ServerSession>
implements ProtocolDelegate<ServerSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSessionDelegate.class);
    private final AtomicBoolean _closed = new AtomicBoolean();

    @Override
    public void command(ServerSession session, Method method) {
        try {
            if (!session.isClosing()) {
                Object asyncCommandMark = session.getAsyncCommandMark();
                this.command(session, method, false);
                Object newOutstanding = session.getAsyncCommandMark();
                if (newOutstanding == null || newOutstanding == asyncCommandMark) {
                    session.processed(method);
                }
                if (newOutstanding != null) {
                    session.completeAsyncCommands();
                }
                if (method.isSync()) {
                    session.awaitCommandCompletion();
                    session.flushProcessed(new Option[0]);
                }
            }
        }
        catch (ConnectionScopedRuntimeException | ServerScopedRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception processing command", (Throwable)e);
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, "Exception processing command: " + e);
        }
    }

    @Override
    public void messageAccept(ServerSession session, MessageAccept method) {
        ServerSession serverSession = session;
        serverSession.accept(method.getTransfers());
        if (!serverSession.isTransactional()) {
            serverSession.recordFuture((ListenableFuture<Void>)Futures.immediateFuture(null), new CommandProcessedAction(serverSession, method));
        }
    }

    @Override
    public void messageReject(ServerSession session, MessageReject method) {
        session.reject(method.getTransfers());
    }

    @Override
    public void messageRelease(ServerSession session, MessageRelease method) {
        session.release(method.getTransfers(), method.getSetRedelivered());
    }

    @Override
    public void messageAcquire(ServerSession session, MessageAcquire method) {
        RangeSet acquiredRanges = session.acquire(method.getTransfers());
        Acquired result = new Acquired(acquiredRanges);
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void messageResume(ServerSession session, MessageResume method) {
        super.messageResume(session, method);
    }

    @Override
    public void messageSubscribe(ServerSession session, MessageSubscribe method) {
        if (!method.hasAcceptMode()) {
            method.setAcceptMode(MessageAcceptMode.EXPLICIT);
        }
        if (!method.hasAcquireMode()) {
            method.setAcquireMode(MessageAcquireMode.PRE_ACQUIRED);
        }
        if (!method.hasQueue()) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not supplied");
        } else {
            String destination = method.getDestination();
            if (destination == null) {
                this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, "Subscriber must provide a destination. The protocol specification marking the destination argument as optional is considered a mistake.");
            } else if (session.getSubscription(destination) != null) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Subscription already exists with destination '" + destination + "'");
            } else {
                String queueName = method.getQueue();
                NamedAddressSpace addressSpace = this.getAddressSpace(session);
                HashSet<MessageSource> sources = new HashSet<MessageSource>();
                MessageSource queue = addressSpace.getAttainedMessageSource(queueName);
                if (method.getArguments() != null && method.getArguments().get("x-multiqueue") instanceof Collection) {
                    for (Object object : (Collection)method.getArguments().get("x-multiqueue")) {
                        String sourceName = String.valueOf(object);
                        if ((sourceName = sourceName.trim()).length() == 0) continue;
                        MessageSource source = addressSpace.getAttainedMessageSource(sourceName);
                        if (source == null) {
                            sources.clear();
                            break;
                        }
                        sources.add(source);
                    }
                    queueName = method.getArguments().get("x-multiqueue").toString();
                } else if (queue != null) {
                    sources.add(queue);
                }
                if (sources.isEmpty()) {
                    this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Queue: " + queueName + " not found");
                } else if (!this.verifySessionAccess(session, sources)) {
                    this.exception(session, method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
                } else {
                    AMQPConnection_0_10 protocolEngine = this.getServerConnection(session).getAmqpConnection();
                    WindowCreditManager creditManager = new WindowCreditManager(0L, 0L);
                    FilterManager filterManager = null;
                    try {
                        filterManager = FilterManagerFactory.createManager(method.getArguments());
                    }
                    catch (AMQInvalidArgumentException amqe) {
                        this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Exception Creating FilterManager");
                        return;
                    }
                    if (method.hasArguments() && method.getArguments().containsKey(AMQPFilterTypes.REPLAY_PERIOD.toString())) {
                        long period;
                        Object value = method.getArguments().get(AMQPFilterTypes.REPLAY_PERIOD.toString());
                        if (value instanceof Number) {
                            period = ((Number)value).longValue();
                        } else if (value instanceof String) {
                            try {
                                period = Long.parseLong(value.toString());
                            }
                            catch (NumberFormatException e) {
                                this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Cannot parse value " + value + " as a number for filter " + AMQPFilterTypes.REPLAY_PERIOD.toString());
                                return;
                            }
                        } else {
                            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Cannot parse value " + value + " as a number for filter " + AMQPFilterTypes.REPLAY_PERIOD.toString());
                            return;
                        }
                        long startingFrom = System.currentTimeMillis() - 1000L * period;
                        if (filterManager == null) {
                            filterManager = new FilterManager();
                        }
                        ArrivalTimeFilter filter = new ArrivalTimeFilter(startingFrom, period == 0L);
                        filterManager.add(filter.getName(), (MessageFilter)filter);
                    }
                    boolean multiQueue = sources.size() > 1;
                    ConsumerTarget_0_10 target = new ConsumerTarget_0_10(session, destination, method.getAcceptMode(), method.getAcquireMode(), MessageFlowMode.WINDOW, creditManager, method.getArguments(), multiQueue);
                    Integer priority = null;
                    if (method.hasArguments() && method.getArguments().containsKey("x-priority")) {
                        Object value = method.getArguments().get("x-priority");
                        if (value instanceof Number) {
                            priority = ((Number)value).intValue();
                        } else if (value instanceof String) {
                            try {
                                priority = Integer.parseInt(value.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    session.register(destination, target);
                    try {
                        EnumSet<ConsumerOption> options = EnumSet.noneOf(ConsumerOption.class);
                        if (method.getAcquireMode() == MessageAcquireMode.PRE_ACQUIRED) {
                            options.add(ConsumerOption.ACQUIRES);
                        }
                        if (method.getAcquireMode() != MessageAcquireMode.NOT_ACQUIRED || method.getAcceptMode() == MessageAcceptMode.EXPLICIT) {
                            options.add(ConsumerOption.SEES_REQUEUES);
                        }
                        if (method.getExclusive()) {
                            options.add(ConsumerOption.EXCLUSIVE);
                        }
                        for (MessageSource source : sources) {
                            source.addConsumer((ConsumerTarget)target, filterManager, MessageTransferMessage.class, destination, options, priority);
                        }
                        target.updateNotifyWorkDesired();
                    }
                    catch (MessageSource.ExistingExclusiveConsumer existing) {
                        this.exception(session, method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an exclusive consumer");
                    }
                    catch (MessageSource.ExistingConsumerPreventsExclusive exclusive) {
                        this.exception(session, method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an existing consumer - can't subscribe exclusively");
                    }
                    catch (AccessControlException e) {
                        this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                    }
                    catch (MessageSource.ConsumerAccessRefused consumerAccessRefused) {
                        this.exception(session, method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an incompatible exclusivity policy");
                    }
                    catch (MessageSource.QueueDeleted queueDeleted) {
                        this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Queue was deleted");
                    }
                }
            }
        }
    }

    protected boolean verifySessionAccess(ServerSession session, Collection<MessageSource> queues) {
        for (MessageSource source : queues) {
            if (this.verifySessionAccess(session, source)) continue;
            return false;
        }
        return true;
    }

    protected boolean verifySessionAccess(ServerSession session, MessageSource queue) {
        return queue.verifySessionAccess((AMQPSession)session.getModelObject());
    }

    private static String getMessageUserId(MessageTransfer xfr) {
        byte[] userIdBytes = xfr.getHeader() == null ? null : (xfr.getHeader().getMessageProperties() == null ? null : xfr.getHeader().getMessageProperties().getUserId());
        return userIdBytes == null ? null : new String(userIdBytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageTransfer(ServerSession ssn, final MessageTransfer xfr) {
        block22: {
            try {
                DeliveryProperties delvProps;
                if (ssn.blockingTimeoutExceeded()) {
                    this.getEventLogger(ssn).message(ChannelMessages.FLOW_CONTROL_IGNORED());
                    ssn.close(311, "Session flow control was requested, but not enforced by sender");
                    break block22;
                }
                if (xfr.getBodySize() > ssn.getConnection().getMaxMessageSize()) {
                    this.exception(ssn, xfr, ExecutionErrorCode.RESOURCE_LIMIT_EXCEEDED, "Message size of " + xfr.getBodySize() + " greater than allowed maximum of " + ssn.getConnection().getMaxMessageSize());
                    break block22;
                }
                MessageDestination destination = this.getDestinationForMessage(ssn, xfr);
                DeliveryProperties deliveryProperties = delvProps = xfr.getHeader() == null ? null : xfr.getHeader().getDeliveryProperties();
                if (delvProps != null && delvProps.hasTtl() && !delvProps.hasExpiration()) {
                    delvProps.setExpiration(System.currentTimeMillis() + delvProps.getTtl());
                }
                MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(xfr);
                NamedAddressSpace virtualHost = this.getAddressSpace(ssn);
                try {
                    ssn.getAMQPConnection().checkAuthorizedMessagePrincipal(ServerSessionDelegate.getMessageUserId(xfr));
                    ssn.authorisePublish(destination, messageMetaData.getRoutingKey(), messageMetaData.isImmediate(), ssn.getAMQPConnection().getLastReadTime());
                }
                catch (AccessControlException e) {
                    ExecutionErrorCode errorCode = ExecutionErrorCode.UNAUTHORIZED_ACCESS;
                    this.exception(ssn, xfr, errorCode, e.getMessage());
                    xfr.dispose();
                    return;
                }
                MessageStore store = virtualHost.getMessageStore();
                StoredMessage<MessageMetaData_0_10> storeMessage = this.createStoreMessage(xfr, messageMetaData, store);
                final MessageTransferMessage message = new MessageTransferMessage(storeMessage, ssn.getReference());
                MessageReference reference = message.newReference();
                try {
                    InstanceProperties instanceProperties = new InstanceProperties(){

                        public Object getProperty(InstanceProperties.Property prop) {
                            switch (prop) {
                                case EXPIRATION: {
                                    return message.getExpiration();
                                }
                                case IMMEDIATE: {
                                    return message.isImmediate();
                                }
                                case MANDATORY: {
                                    return (delvProps == null || !delvProps.getDiscardUnroutable()) && xfr.getAcceptMode() == MessageAcceptMode.EXPLICIT;
                                }
                                case PERSISTENT: {
                                    return message.isPersistent();
                                }
                                case REDELIVERED: {
                                    return delvProps.getRedelivered();
                                }
                            }
                            return null;
                        }
                    };
                    RoutingResult<MessageTransferMessage> routingResult = ssn.enqueue(message, instanceProperties, destination);
                    boolean explictlyRejected = routingResult.containsReject(new RejectType[]{RejectType.LIMIT_EXCEEDED});
                    if (!routingResult.hasRoutes() || explictlyRejected) {
                        boolean discardUnroutable;
                        boolean closeWhenNoRoute = ssn.getAMQPConnection().getPort().getCloseWhenNoRoute();
                        boolean bl = discardUnroutable = delvProps != null && delvProps.getDiscardUnroutable();
                        if (!discardUnroutable && xfr.getAcceptMode() == MessageAcceptMode.EXPLICIT) {
                            RangeSet rejects = RangeSetFactory.createRangeSet();
                            rejects.add(xfr.getId());
                            MessageReject reject = new MessageReject(rejects, MessageRejectCode.UNROUTABLE, "Unroutable", new Option[0]);
                            ssn.invoke(reject);
                        } else {
                            if (!discardUnroutable && closeWhenNoRoute && explictlyRejected) {
                                ExecutionErrorCode code = ExecutionErrorCode.RESOURCE_LIMIT_EXCEEDED;
                                String errorMessage = String.format("No route for message with destination '%s' and routing key '%s' : %s", xfr.getDestination(), message.getInitialRoutingAddress(), routingResult.getRejectReason());
                                ExecutionException ex = new ExecutionException();
                                ex.setErrorCode(code);
                                ex.setDescription(errorMessage);
                                ssn.invoke(ex);
                                ssn.close(506, errorMessage);
                                return;
                            }
                            this.getEventLogger(ssn).message(ExchangeMessages.DISCARDMSG((String)destination.getName(), (String)messageMetaData.getRoutingKey()));
                        }
                    }
                    if (ssn.isTransactional()) {
                        ssn.processed(xfr);
                    } else {
                        ssn.recordFuture((ListenableFuture<Void>)Futures.immediateFuture(null), new CommandProcessedAction(ssn, xfr));
                    }
                }
                catch (VirtualHostUnavailableException e) {
                    this.getServerConnection(ssn).sendConnectionCloseAsync(ConnectionCloseCode.CONNECTION_FORCED, e.getMessage());
                }
                finally {
                    reference.release();
                }
            }
            finally {
                xfr.dispose();
            }
        }
    }

    private StoredMessage<MessageMetaData_0_10> createStoreMessage(MessageTransfer xfr, MessageMetaData_0_10 messageMetaData, MessageStore store) {
        MessageHandle addedMessage = store.addMessage((StorableMessageMetaData)messageMetaData);
        QpidByteBuffer body = xfr.getBody();
        if (body != null) {
            addedMessage.addContent(body);
        }
        StoredMessage storedMessage = addedMessage.allContentAdded();
        return storedMessage;
    }

    @Override
    public void messageCancel(ServerSession session, MessageCancel method) {
        String destination = method.getDestination();
        ConsumerTarget_0_10 sub = session.getSubscription(destination);
        if (sub == null) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            session.unregister(sub);
        }
    }

    @Override
    public void messageFlush(ServerSession session, MessageFlush method) {
        String destination = method.getDestination();
        ConsumerTarget_0_10 sub = session.getSubscription(destination);
        if (sub == null) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.flush();
        }
    }

    @Override
    public void txSelect(ServerSession session, TxSelect method) {
        session.selectTx();
    }

    @Override
    public void txCommit(ServerSession session, TxCommit method) {
        session.commit();
    }

    @Override
    public void txRollback(ServerSession session, TxRollback method) {
        session.rollback();
    }

    @Override
    public void dtxSelect(ServerSession session, DtxSelect method) {
        session.selectDtx();
    }

    @Override
    public void dtxStart(ServerSession session, DtxStart method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            session.startDtx(method.getXid(), method.getJoin(), method.getResume());
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (JoinAndResumeDtxException e) {
            this.exception(session, method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Unknown xid " + method.getXid());
        }
        catch (AlreadyKnownDtxException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Xid already started an neither join nor resume set" + method.getXid());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    @Override
    public void dtxEnd(ServerSession session, DtxEnd method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                session.endDtx(method.getXid(), method.getFail(), method.getSuspend());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (NotAssociatedDtxException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (SuspendAndFailDtxException e) {
            this.exception(session, method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    @Override
    public void dtxCommit(ServerSession session, DtxCommit method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                session.commitDtx(method.getXid(), method.getOnePhase());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    @Override
    public void dtxForget(ServerSession session, DtxForget method) {
        try {
            session.forgetDtx(method.getXid());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
    }

    @Override
    public void dtxGetTimeout(ServerSession session, DtxGetTimeout method) {
        GetTimeoutResult result = new GetTimeoutResult();
        try {
            result.setTimeout(session.getTimeoutDtx(method.getXid()));
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    @Override
    public void dtxPrepare(ServerSession session, DtxPrepare method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                session.prepareDtx(method.getXid());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    @Override
    public void dtxRecover(ServerSession session, DtxRecover method) {
        RecoverResult result = new RecoverResult();
        List<Object> inDoubt = session.recoverDtx();
        result.setInDoubt(inDoubt);
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void dtxRollback(ServerSession session, DtxRollback method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                session.rollbackDtx(method.getXid());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    @Override
    public void dtxSetTimeout(ServerSession session, DtxSetTimeout method) {
        try {
            session.setTimeoutDtx(method.getXid(), method.getTimeout());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    @Override
    public void executionSync(ServerSession ssn, ExecutionSync sync) {
        ssn.awaitCommandCompletion();
        ssn.syncPoint();
    }

    @Override
    public void exchangeDeclare(ServerSession session, ExchangeDeclare method) {
        String exchangeName = method.getExchange();
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        String alternateExchangeName = method.getAlternateExchange();
        if (this.nameNullOrEmpty(method.getExchange())) {
            if (!"direct".equals(method.getType())) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare default exchange  of type direct to " + method.getType() + ".");
            }
            if (!this.nameNullOrEmpty(alternateExchangeName)) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to set alternate exchange of the default exchange  to " + alternateExchangeName + ".");
            }
        } else if (method.getPassive()) {
            Exchange<?> exchange = this.getExchange(session, exchangeName);
            if (exchange == null) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "not-found: exchange-name '" + exchangeName + "'");
            } else if (!exchange.getType().equals(method.getType()) && method.getType() != null && method.getType().length() > 0) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + method.getType() + ".");
            }
        } else {
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (method.hasArguments()) {
                    attributes.putAll(method.getArguments());
                }
                attributes.put("name", method.getExchange());
                attributes.put("type", method.getType());
                attributes.put("durable", method.getDurable());
                attributes.put("lifetimePolicy", method.getAutoDelete() ? LifetimePolicy.DELETE_ON_NO_LINKS : LifetimePolicy.PERMANENT);
                if (method.hasAlternateExchange() && !this.nameNullOrEmpty(alternateExchangeName)) {
                    this.validateAlternateExchangeIsNotQueue(addressSpace, alternateExchangeName);
                    attributes.put("alternateBinding", Collections.singletonMap("destination", alternateExchangeName));
                }
                this.validateExchangeDeclareArguments(attributes, session.getAMQPConnection().getModel());
                addressSpace.createMessageDestination(Exchange.class, attributes);
            }
            catch (ReservedExchangeNameException e) {
                Exchange<?> existingExchange = this.getExchange(session, exchangeName);
                if (existingExchange == null || !existingExchange.getType().equals(method.getType()) || method.hasAlternateExchange() && (existingExchange.getAlternateBinding() == null || !alternateExchangeName.equals(existingExchange.getAlternateBinding().getDestination()))) {
                    this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved name or prefix.");
                }
            }
            catch (UnknownAlternateBindingException e) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, String.format("Unknown alternate exchange '%s'", e.getAlternateBindingName()));
            }
            catch (NoFactoryForTypeException e) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Unknown Exchange Type: " + method.getType());
            }
            catch (AbstractConfiguredObject.DuplicateNameException e) {
                Exchange exchange = (Exchange)e.getExisting();
                if (!exchange.getType().equals(method.getType())) {
                    this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + method.getType() + ".");
                } else if (method.hasAlternateExchange() && (exchange.getAlternateBinding() == null || !alternateExchangeName.equals(exchange.getAlternateBinding().getDestination()))) {
                    this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to change alternate exchange of: " + exchangeName + " from " + exchange.getAlternateBinding() + " to " + alternateExchangeName + ".");
                }
            }
            catch (AccessControlException e) {
                this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
            catch (IllegalArgumentException | IllegalConfigurationException e) {
                this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, e.getMessage());
            }
        }
    }

    private void validateExchangeDeclareArguments(Map<String, Object> attributes, Model model) {
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        ArrayList types = new ArrayList(typeRegistry.getAttributeTypes(Exchange.class).values());
        typeRegistry.getTypeSpecialisations(Exchange.class).forEach(type -> types.addAll(typeRegistry.getTypeSpecificAttributes(type)));
        Set unsupported = attributes.keySet().stream().filter(name -> types.stream().noneMatch(a -> Objects.equals(name, a.getName()) && !a.isDerived())).collect(Collectors.toSet());
        if (!unsupported.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unsupported exchange declare arguments : %s", String.join((CharSequence)",", unsupported)));
        }
    }

    private void exception(ServerSession session, Method method, ExecutionErrorCode errorCode, String description) {
        ExecutionException ex = new ExecutionException();
        ex.setErrorCode(errorCode);
        ex.setCommandId(method.getId());
        ex.setDescription(description);
        session.invoke(ex);
        session.close(errorCode.getValue(), description);
    }

    private Exchange<?> getExchange(ServerSession session, String exchangeName) {
        return this.getExchange(this.getAddressSpace(session), exchangeName);
    }

    private Exchange<?> getExchange(NamedAddressSpace addressSpace, String exchangeName) {
        MessageDestination destination = addressSpace.getAttainedMessageDestination(exchangeName);
        return destination instanceof Exchange ? (Exchange)destination : null;
    }

    private Queue<?> getQueue(NamedAddressSpace addressSpace, String name) {
        MessageSource source = addressSpace.getAttainedMessageSource(name);
        return source instanceof Queue ? (Queue)source : null;
    }

    private MessageDestination getDestinationForMessage(ServerSession ssn, MessageTransfer xfr) {
        MessageDestination destination;
        NamedAddressSpace addressSpace = this.getAddressSpace(ssn);
        if (xfr.hasDestination()) {
            destination = addressSpace.getAttainedMessageDestination(xfr.getDestination());
            if (destination == null) {
                destination = addressSpace.getDefaultDestination();
            } else {
                DeliveryProperties delvProps;
                Header header = xfr.getHeader();
                if (header == null) {
                    delvProps = new DeliveryProperties();
                    header = new Header(delvProps, null, null);
                    xfr.setHeader(header);
                } else if (header.getDeliveryProperties() == null) {
                    delvProps = new DeliveryProperties();
                    header = new Header(delvProps, header.getMessageProperties(), header.getNonStandardProperties());
                    xfr.setHeader(header);
                } else {
                    delvProps = header.getDeliveryProperties();
                }
                if (delvProps.getExchange() == null && !xfr.getDestination().equals(delvProps.getRoutingKey())) {
                    delvProps.setExchange(xfr.getDestination());
                }
            }
        } else {
            destination = xfr.getHeader() != null && xfr.getHeader().getDeliveryProperties() != null && xfr.getHeader().getDeliveryProperties().getExchange() != null ? addressSpace.getAttainedMessageDestination(xfr.getHeader().getDeliveryProperties().getExchange()) : addressSpace.getDefaultDestination();
        }
        return destination;
    }

    private NamedAddressSpace getAddressSpace(ServerSession session) {
        ServerConnection conn = this.getServerConnection(session);
        return conn.getAddressSpace();
    }

    private ServerConnection getServerConnection(ServerSession session) {
        return session.getConnection();
    }

    private <T> T getContextValue(ServerSession session, Class<T> clazz, String name) {
        return (T)this.getServerConnection(session).getAmqpConnection().getContextProvider().getContextValue(clazz, name);
    }

    private EventLogger getEventLogger(ServerSession session) {
        return this.getServerConnection(session).getAmqpConnection().getEventLogger();
    }

    @Override
    public void exchangeDelete(ServerSession session, ExchangeDelete method) {
        if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, "Delete not allowed for default exchange");
            return;
        }
        Exchange<?> exchange = this.getExchange(session, method.getExchange());
        if (exchange == null) {
            this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "No such exchange '" + method.getExchange() + "'");
        } else if (method.getIfUnused() && exchange.hasBindings()) {
            this.exception(session, method, ExecutionErrorCode.PRECONDITION_FAILED, "Exchange has bindings");
        } else {
            try {
                exchange.delete();
            }
            catch (MessageDestinationIsAlternateException e) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Exchange in use as an alternate binding destination");
            }
            catch (RequiredExchangeException e) {
                this.exception(session, method, ExecutionErrorCode.NOT_ALLOWED, "Exchange '" + method.getExchange() + "' cannot be deleted");
            }
            catch (AccessControlException e) {
                this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
        }
    }

    private boolean nameNullOrEmpty(String name) {
        return name == null || name.length() == 0;
    }

    @Override
    public void exchangeQuery(ServerSession session, ExchangeQuery method) {
        ExchangeQueryResult result = new ExchangeQueryResult();
        String exchangeName = method.getName();
        if (this.nameNullOrEmpty(exchangeName)) {
            result.setDurable(true);
            result.setType("direct");
            result.setNotFound(false);
        } else {
            Exchange<?> exchange = this.getExchange(session, exchangeName);
            if (exchange != null) {
                result.setDurable(exchange.isDurable());
                result.setType(exchange.getType());
                result.setNotFound(false);
            } else {
                result.setNotFound(true);
            }
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void exchangeBind(ServerSession session, ExchangeBind method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!method.hasQueue()) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else {
            String exchangeName = method.getExchange();
            if (this.nameNullOrEmpty(exchangeName)) {
                this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, "Bind not allowed for default exchange");
            } else {
                if (!method.hasBindingKey()) {
                    method.setBindingKey(method.getQueue());
                }
                Queue<?> queue = this.getQueue(addressSpace, method.getQueue());
                Exchange<?> exchange = this.getExchange(addressSpace, exchangeName);
                if (queue == null) {
                    this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
                } else if (exchange == null) {
                    this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + exchangeName + "' not found");
                } else if (!(!exchange.getType().equals("headers") || method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey("x-match"))) {
                    this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, "Bindings to an exchange of type headers require an x-match header");
                } else if (!exchange.isBound(method.getBindingKey(), method.getArguments(), queue)) {
                    try {
                        exchange.addBinding(method.getBindingKey(), queue, method.getArguments());
                    }
                    catch (AccessControlException e) {
                        this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                    }
                    catch (AMQInvalidArgumentException e) {
                        this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, String.format("Cannot bind queue '%s' to exchange '%s' due to invalid argument : %s", queue.getName(), exchangeName, e.getMessage()));
                    }
                }
            }
        }
    }

    @Override
    public void exchangeUnbind(ServerSession session, ExchangeUnbind method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!method.hasQueue()) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, "Unbind not allowed for default exchange");
        } else if (!method.hasBindingKey()) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "binding-key not set");
        } else {
            Queue<?> queue = this.getQueue(addressSpace, method.getQueue());
            Exchange<?> exchange = this.getExchange(addressSpace, method.getExchange());
            if (queue == null) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else {
                try {
                    if (exchange.hasBinding(method.getBindingKey(), queue)) {
                        exchange.deleteBinding(method.getBindingKey(), queue);
                    }
                }
                catch (AccessControlException e) {
                    this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    @Override
    public void exchangeBound(ServerSession session, ExchangeBound method) {
        Exchange<?> exchange;
        boolean isDefaultExchange;
        ExchangeBoundResult result = new ExchangeBoundResult();
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!this.nameNullOrEmpty(method.getExchange())) {
            isDefaultExchange = false;
            exchange = this.getExchange(addressSpace, method.getExchange());
            if (exchange == null) {
                result.setExchangeNotFound(true);
            }
        } else {
            isDefaultExchange = true;
            exchange = null;
        }
        if (isDefaultExchange) {
            if (method.hasQueue()) {
                Queue<?> queue = this.getQueue(session, method.getQueue());
                if (queue == null) {
                    result.setQueueNotFound(true);
                } else if (method.hasBindingKey() && !method.getBindingKey().equals(method.getQueue())) {
                    result.setKeyNotMatched(true);
                }
            } else if (method.hasBindingKey() && this.getQueue(session, method.getBindingKey()) == null) {
                result.setKeyNotMatched(true);
            }
            if (method.hasArguments() && !method.getArguments().isEmpty()) {
                result.setArgsNotMatched(true);
            }
        } else if (method.hasQueue()) {
            MessageSource source = this.getMessageSource(session, method.getQueue());
            if (source == null) {
                result.setQueueNotFound(true);
            }
            if (source == null || source instanceof Queue) {
                Queue queue = (Queue)source;
                if (exchange != null && queue != null) {
                    boolean queueMatched = exchange.isBound(queue);
                    result.setQueueNotMatched(!queueMatched);
                    if (method.hasBindingKey()) {
                        if (queueMatched) {
                            boolean keyMatched = exchange.isBound(method.getBindingKey(), queue);
                            result.setKeyNotMatched(!keyMatched);
                            if (method.hasArguments()) {
                                if (keyMatched) {
                                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments(), queue));
                                } else {
                                    result.setArgsNotMatched(!exchange.isBound(method.getArguments(), queue));
                                }
                            }
                        } else {
                            boolean keyMatched = exchange.isBound(method.getBindingKey());
                            result.setKeyNotMatched(!keyMatched);
                            if (method.hasArguments()) {
                                if (keyMatched) {
                                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                                } else {
                                    result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                                }
                            }
                        }
                    } else if (method.hasArguments()) {
                        if (queueMatched) {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments(), queue));
                        } else {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                        }
                    }
                } else if (exchange != null && method.hasBindingKey()) {
                    boolean keyMatched = exchange.isBound(method.getBindingKey());
                    result.setKeyNotMatched(!keyMatched);
                    if (method.hasArguments()) {
                        if (keyMatched) {
                            result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                        } else {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                        }
                    }
                }
            }
        } else if (exchange != null && method.hasBindingKey()) {
            boolean keyMatched = exchange.isBound(method.getBindingKey());
            result.setKeyNotMatched(!keyMatched);
            if (method.hasArguments()) {
                if (keyMatched) {
                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                } else {
                    result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                }
            }
        } else if (exchange != null && method.hasArguments()) {
            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    private MessageSource getMessageSource(ServerSession session, String queue) {
        return this.getAddressSpace(session).getAttainedMessageSource(queue);
    }

    private Queue<?> getQueue(ServerSession session, String queue) {
        return this.getQueue(this.getAddressSpace(session), queue);
    }

    @Override
    public void queueDeclare(ServerSession session, QueueDeclare method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        String queueName = method.getQueue();
        boolean exclusive = method.getExclusive();
        boolean autoDelete = method.getAutoDelete();
        if (method.getPassive()) {
            Queue<?> queue = this.getQueue(addressSpace, queueName);
            if (queue == null) {
                String description = "Queue: " + queueName + " not found on VirtualHost(" + addressSpace + ").";
                ExecutionErrorCode errorCode = ExecutionErrorCode.NOT_FOUND;
                this.exception(session, method, errorCode, description);
            } else if (exclusive) {
                if (queue.getExclusive() == ExclusivityPolicy.NONE) {
                    String description = "Cannot passively declare queue ('" + queueName + "') as exclusive as queue with same name is already declared as non-exclusive";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, method, errorCode, description);
                } else if (!this.verifySessionAccess(session, (MessageSource)queue)) {
                    String description = "Cannot passively declare queue('" + queueName + "'), as exclusive queue with same name declared on another session";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, method, errorCode, description);
                }
            }
        } else {
            try {
                Map arguments = QueueArgumentsConverter.convertWireArgsToModel((String)queueName, method.getArguments(), (Model)session.getAMQPConnection().getModel());
                String alternateExchangeName = method.getAlternateExchange();
                if (method.hasAlternateExchange() && !this.nameNullOrEmpty(alternateExchangeName)) {
                    this.validateAlternateExchangeIsNotQueue(addressSpace, alternateExchangeName);
                    arguments.put("alternateBinding", Collections.singletonMap("destination", alternateExchangeName));
                }
                arguments.put("name", queueName);
                if (!arguments.containsKey("lifetimePolicy")) {
                    LifetimePolicy lifetime = autoDelete ? (exclusive ? LifetimePolicy.DELETE_ON_SESSION_END : LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS) : LifetimePolicy.PERMANENT;
                    arguments.put("lifetimePolicy", lifetime);
                }
                if (!arguments.containsKey("exclusive")) {
                    ExclusivityPolicy exclusivityPolicy = exclusive ? ExclusivityPolicy.SESSION : ExclusivityPolicy.NONE;
                    arguments.put("exclusive", exclusivityPolicy);
                }
                arguments.put("durable", method.getDurable());
                Queue queue = (Queue)addressSpace.createMessageSource(Queue.class, arguments);
            }
            catch (AbstractConfiguredObject.DuplicateNameException qe) {
                Queue queue = (Queue)qe.getExisting();
                if (!this.verifySessionAccess(session, (MessageSource)queue)) {
                    String description = "Cannot declare queue('" + queueName + "'), as exclusive queue with same name declared on another session";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, method, errorCode, description);
                }
            }
            catch (AccessControlException e) {
                this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
            catch (UnknownAlternateBindingException e) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, String.format("Unknown alternate exchange '%s'", e.getAlternateBindingName()));
            }
            catch (IllegalArgumentException | IllegalConfigurationException e) {
                this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, e.getMessage());
            }
        }
    }

    private void validateAlternateExchangeIsNotQueue(NamedAddressSpace addressSpace, String alternateExchangeName) {
        MessageDestination alternateMessageDestination = addressSpace.getAttainedMessageDestination(alternateExchangeName, false);
        if (alternateMessageDestination != null && !(alternateMessageDestination instanceof Exchange)) {
            throw new IllegalConfigurationException(String.format("Alternate exchange '%s' is not a destination of type 'exchange'.", alternateExchangeName));
        }
    }

    @Override
    public void queueDelete(ServerSession session, QueueDelete method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, method, ExecutionErrorCode.INVALID_ARGUMENT, "No queue name supplied");
        } else {
            Queue<?> queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else if (!this.verifySessionAccess(session, (MessageSource)queue)) {
                this.exception(session, method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
            } else if (method.getIfEmpty() && !queue.isEmpty()) {
                this.exception(session, method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " not empty");
            } else if (method.getIfUnused() && !queue.isUnused()) {
                this.exception(session, method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " in use");
            } else {
                try {
                    queue.delete();
                }
                catch (AccessControlException e) {
                    this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    @Override
    public void queuePurge(ServerSession session, QueuePurge method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "No queue name supplied");
        } else {
            Queue<?> queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else {
                try {
                    queue.clearQueue();
                }
                catch (AccessControlException e) {
                    this.exception(session, method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    @Override
    public void queueQuery(ServerSession session, QueueQuery method) {
        QueueQueryResult result = new QueueQueryResult();
        MessageSource source = this.getMessageSource(session, method.getQueue());
        if (source != null) {
            result.setQueue(source.getName());
            if (source instanceof Queue) {
                Queue queue = (Queue)source;
                result.setDurable(queue.isDurable());
                result.setExclusive(queue.isExclusive());
                result.setAutoDelete(queue.getLifetimePolicy() != LifetimePolicy.PERMANENT);
                LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
                Collection availableAttrs = queue.getAvailableAttributes();
                for (String attrName : availableAttrs) {
                    arguments.put(attrName, queue.getAttribute(attrName));
                }
                result.setArguments(QueueArgumentsConverter.convertModelArgsToWire(arguments));
                result.setMessageCount(queue.getQueueDepthMessages());
                result.setSubscriberCount(queue.getConsumerCount());
            } else {
                result.setDurable(true);
                result.setExclusive(false);
                result.setAutoDelete(false);
                result.setMessageCount(Integer.MAX_VALUE);
                result.setSubscriberCount(0L);
            }
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void messageSetFlowMode(ServerSession session, MessageSetFlowMode sfm) {
        String destination = sfm.getDestination();
        ConsumerTarget_0_10 sub = session.getSubscription(destination);
        if (sub == null) {
            this.exception(session, sfm, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else if (sub.isFlowModeChangeAllowed()) {
            sub.setFlowMode(sfm.getFlowMode());
        } else {
            this.exception(session, sfm, ExecutionErrorCode.PRECONDITION_FAILED, "destination '" + destination + "' has credit");
        }
    }

    @Override
    public void messageStop(ServerSession session, MessageStop stop) {
        String destination = stop.getDestination();
        ConsumerTarget_0_10 sub = session.getSubscription(destination);
        if (sub == null) {
            this.exception(session, stop, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.stop();
        }
    }

    @Override
    public void messageFlow(ServerSession session, MessageFlow flow) {
        String destination = flow.getDestination();
        ConsumerTarget_0_10 sub = session.getSubscription(destination);
        if (sub == null) {
            this.exception(session, flow, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.addCredit(flow.getUnit(), flow.getValue());
        }
    }

    public void closed(ServerSession session) {
        if (this._closed.compareAndSet(false, true)) {
            session.stopSubscriptions();
            session.onClose();
            session.unregisterSubscriptions();
        }
    }

    public void detached(ServerSession session) {
        this.closed(session);
    }

    @Override
    public void init(ServerSession ssn, ProtocolHeader hdr) {
        LOGGER.warn("INIT: [{}] {}", (Object)ssn, (Object)hdr);
    }

    @Override
    public void control(ServerSession ssn, Method method) {
        method.dispatch(ssn, this);
    }

    public void command(ServerSession ssn, Method method, boolean processed) {
        ssn.identify(method);
        method.dispatch(ssn, this);
        if (processed) {
            ssn.processed(method);
        }
    }

    @Override
    public void error(ServerSession ssn, ProtocolError error) {
        LOGGER.warn("ERROR: [{}] {}", (Object)ssn, (Object)error);
    }

    @Override
    public void handle(ServerSession ssn, Method method) {
        LOGGER.warn("UNHANDLED: [{}] {}", (Object)ssn, (Object)method);
    }

    @Override
    public void sessionRequestTimeout(ServerSession ssn, SessionRequestTimeout t) {
        if (t.getTimeout() == 0L) {
            ssn.setClose(true);
        }
        ssn.sessionTimeout(0L, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionAttached(ServerSession ssn, SessionAttached atc) {
        ssn.setState(ServerSession.State.OPEN);
        Object object = ssn.getStateLock();
        synchronized (object) {
            ssn.getStateLock().notifyAll();
        }
    }

    @Override
    public void sessionTimeout(ServerSession ssn, SessionTimeout t) {
    }

    @Override
    public void sessionCompleted(ServerSession ssn, SessionCompleted cmp) {
        RangeSet ranges = cmp.getCommands();
        RangeSet known = null;
        if (ranges != null) {
            if (ranges.size() == 1) {
                Range range = ranges.getFirst();
                boolean advanced = ssn.complete(range.getLower(), range.getUpper());
                if (advanced && cmp.getTimelyReply()) {
                    known = range;
                }
            } else {
                if (cmp.getTimelyReply()) {
                    known = RangeSetFactory.createRangeSet();
                }
                for (Range range : ranges) {
                    boolean advanced = ssn.complete(range.getLower(), range.getUpper());
                    if (!advanced || known == null) continue;
                    known.add(range);
                }
            }
        } else if (cmp.getTimelyReply()) {
            known = RangeSetFactory.createRangeSet();
        }
        if (known != null) {
            ssn.sessionKnownCompleted(known, new Option[0]);
        }
    }

    @Override
    public void sessionKnownCompleted(ServerSession ssn, SessionKnownCompleted kcmp) {
        RangeSet kc = kcmp.getCommands();
        if (kc != null) {
            ssn.knownComplete(kc);
        }
    }

    @Override
    public void sessionFlush(ServerSession ssn, SessionFlush flush) {
        if (flush.getCompleted()) {
            ssn.flushProcessed(new Option[0]);
        }
        if (flush.getConfirmed()) {
            ssn.flushProcessed(new Option[0]);
        }
        if (flush.getExpected()) {
            ssn.flushExpected();
        }
    }

    @Override
    public void sessionCommandPoint(ServerSession ssn, SessionCommandPoint scp) {
        ssn.commandPoint(scp.getCommandId());
    }

    @Override
    public void executionResult(ServerSession ssn, ExecutionResult result) {
        ssn.result(result.getCommandId(), result.getValue());
    }

    @Override
    public void executionException(ServerSession ssn, ExecutionException exc) {
        ssn.setException(exc);
        LOGGER.error("session exception", (Object)exc);
        ssn.closed();
    }

    private static class CommandProcessedAction
    implements ServerTransaction.Action {
        private final ServerSession _serverSession;
        private final Method _method;

        public CommandProcessedAction(ServerSession serverSession, Method xfr) {
            this._serverSession = serverSession;
            this._method = xfr;
        }

        public void postCommit() {
            this._serverSession.processed(this._method);
        }

        public void onRollback() {
        }
    }
}

