/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class ConnectionStart
extends Method {
    public static final int TYPE = 257;
    private short packing_flags = 0;
    private Map<String, Object> serverProperties;
    private List<Object> mechanisms;
    private List<Object> locales;

    @Override
    public final int getStructType() {
        return 257;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionStart() {
    }

    public ConnectionStart(Map<String, Object> serverProperties, List<Object> mechanisms, List<Object> locales, Option ... _options) {
        if (serverProperties != null) {
            this.setServerProperties(serverProperties);
        }
        if (mechanisms != null) {
            this.setMechanisms(mechanisms);
        }
        if (locales != null) {
            this.setLocales(locales);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionStart(context, this);
    }

    public final boolean hasServerProperties() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionStart clearServerProperties() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.serverProperties = null;
        this.setDirty(true);
        return this;
    }

    public final Map<String, Object> getServerProperties() {
        return this.serverProperties;
    }

    public final ConnectionStart setServerProperties(Map<String, Object> value) {
        this.serverProperties = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ConnectionStart serverProperties(Map<String, Object> value) {
        return this.setServerProperties(value);
    }

    public final boolean hasMechanisms() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionStart clearMechanisms() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.mechanisms = null;
        this.setDirty(true);
        return this;
    }

    public final List<Object> getMechanisms() {
        return this.mechanisms;
    }

    public final ConnectionStart setMechanisms(List<Object> value) {
        this.mechanisms = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ConnectionStart mechanisms(List<Object> value) {
        return this.setMechanisms(value);
    }

    public final boolean hasLocales() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ConnectionStart clearLocales() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.locales = null;
        this.setDirty(true);
        return this;
    }

    public final List<Object> getLocales() {
        return this.locales;
    }

    public final ConnectionStart setLocales(List<Object> value) {
        this.locales = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final ConnectionStart locales(List<Object> value) {
        return this.setLocales(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeMap(this.serverProperties);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeArray(this.mechanisms);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeArray(this.locales);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.serverProperties = dec.readMap();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.mechanisms = dec.readArray();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.locales = dec.readArray();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("serverProperties", this.getServerProperties());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("mechanisms", this.getMechanisms());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("locales", this.getLocales());
        }
        return result;
    }
}

