/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport.mimecontentconverter;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.transport.BBEncoder;
import org.apache.qpid.server.protocol.v0_10.transport.EncoderUtils;

@PluggableService
public class ListToAmqpListConverter
implements ObjectToMimeContentConverter<List> {
    public String getType() {
        return this.getMimeType();
    }

    public Class<List> getObjectClass() {
        return List.class;
    }

    public int getRank() {
        return 0;
    }

    public String getMimeType() {
        return "amqp/list";
    }

    public boolean isAcceptable(List list) {
        return EncoderUtils.isEncodable(list);
    }

    public byte[] toMimeContent(List list) {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeList(list);
        ByteBuffer buf = encoder.buffer();
        int remaining = buf.remaining();
        byte[] data = new byte[remaining];
        buf.get(data);
        return data;
    }
}

