/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.Collection;
import java.util.Set;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.message.AMQMessageHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderBodyAdapter
implements AMQMessageHeader {
    private final ContentHeaderBody _contentHeaderBody;

    public ContentHeaderBodyAdapter(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    private BasicContentHeaderProperties getProperties() {
        return (BasicContentHeaderProperties)this._contentHeaderBody.getProperties();
    }

    public String getCorrelationId() {
        return this.getProperties().getCorrelationIdAsString();
    }

    public long getExpiration() {
        return this.getProperties().getExpiration();
    }

    public String getUserId() {
        return this.getProperties().getUserIdAsString();
    }

    public String getAppId() {
        return this.getProperties().getAppIdAsString();
    }

    public String getMessageId() {
        return this.getProperties().getMessageIdAsString();
    }

    public String getMimeType() {
        return this.getProperties().getContentTypeAsString();
    }

    public String getEncoding() {
        return this.getProperties().getEncodingAsString();
    }

    public byte getPriority() {
        return this.getProperties().getPriority();
    }

    public long getTimestamp() {
        return this.getProperties().getTimestamp();
    }

    public String getType() {
        return this.getProperties().getTypeAsString();
    }

    public String getReplyTo() {
        return this.getProperties().getReplyToAsString();
    }

    public String getReplyToExchange() {
        return this.getReplyTo();
    }

    public String getReplyToRoutingKey() {
        return this.getReplyTo();
    }

    public Object getHeader(String name) {
        FieldTable ft = this.getProperties().getHeaders();
        return ft.get(name);
    }

    public boolean containsHeaders(Set<String> names) {
        FieldTable ft = this.getProperties().getHeaders();
        for (String name : names) {
            if (ft.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getHeaderNames() {
        FieldTable ft = this.getProperties().getHeaders();
        return ft.keys();
    }

    public boolean containsHeader(String name) {
        FieldTable ft = this.getProperties().getHeaders();
        return ft.containsKey(name);
    }
}

