/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.Filterable;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingMessage
implements Filterable,
InboundMessage,
EnqueableMessage,
MessageContentSource {
    private static final Logger _logger = Logger.getLogger(IncomingMessage.class);
    private final MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private long _bodyLengthReceived = 0L;
    private List<? extends BaseQueue> _destinationQueues;
    private long _expiration;
    private Exchange _exchange;
    private List<ContentChunk> _contentChunks = new ArrayList<ContentChunk>();
    private MessageMetaData _messageMetaData;
    private StoredMessage<MessageMetaData> _storedMessageHandle;
    private Object _connectionReference;

    public IncomingMessage(MessagePublishInfo info) {
        this(info, null);
    }

    public IncomingMessage(MessagePublishInfo info, Object reference) {
        this._messagePublishInfo = info;
        this._connectionReference = reference;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) throws AMQException {
        this._contentHeaderBody = contentHeaderBody;
    }

    public void setExpiration() {
        this._expiration = ((BasicContentHeaderProperties)this._contentHeaderBody.getProperties()).getExpiration();
    }

    public MessageMetaData headersReceived(long currentTime) {
        this._messageMetaData = new MessageMetaData(this._messagePublishInfo, this._contentHeaderBody, 0, currentTime);
        return this._messageMetaData;
    }

    public List<? extends BaseQueue> getDestinationQueues() {
        return this._destinationQueues;
    }

    public void addContentBodyFrame(ContentChunk contentChunk) throws AMQException {
        this._bodyLengthReceived += (long)contentChunk.getSize();
        this._contentChunks.add(contentChunk);
    }

    public boolean allContentReceived() {
        return this._bodyLengthReceived == this.getContentHeader().getBodySize();
    }

    public AMQShortString getExchange() {
        return this._messagePublishInfo.getExchange();
    }

    public AMQShortString getRoutingKeyShortString() {
        return this._messagePublishInfo.getRoutingKey();
    }

    public String getRoutingKey() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public String getBinding() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public boolean isMandatory() {
        return this._messagePublishInfo.isMandatory();
    }

    public boolean isImmediate() {
        return this._messagePublishInfo.isImmediate();
    }

    public ContentHeaderBody getContentHeader() {
        return this._contentHeaderBody;
    }

    public AMQMessageHeader getMessageHeader() {
        return this._messageMetaData.getMessageHeader();
    }

    public boolean isPersistent() {
        return this.getContentHeader().getProperties() instanceof BasicContentHeaderProperties && ((BasicContentHeaderProperties)this.getContentHeader().getProperties()).getDeliveryMode() == 2;
    }

    public boolean isRedelivered() {
        return false;
    }

    public long getSize() {
        return this.getContentHeader().getBodySize();
    }

    public long getMessageNumber() {
        return this._storedMessageHandle.getMessageNumber();
    }

    public void setExchange(Exchange e) {
        this._exchange = e;
    }

    public void route() {
        this.enqueue(this._exchange.route((InboundMessage)this));
    }

    public void enqueue(List<? extends BaseQueue> queues) {
        this._destinationQueues = queues;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public int getBodyCount() throws AMQException {
        return this._contentChunks.size();
    }

    public ContentChunk getContentChunk(int index) {
        return this._contentChunks.get(index);
    }

    public int getContent(ByteBuffer buf, int offset) {
        int pos = 0;
        int written = 0;
        for (ContentChunk cb : this._contentChunks) {
            ByteBuffer data = ByteBuffer.wrap(cb.getData());
            if (offset + written >= pos && offset < pos + data.limit()) {
                ByteBuffer src = data.duplicate();
                src.position(offset + written - pos);
                src = src.slice();
                if (buf.remaining() < src.limit()) {
                    src.limit(buf.remaining());
                }
                int count = src.limit();
                buf.put(src);
                written += count;
                if (buf.remaining() == 0) break;
            }
            pos += data.limit();
        }
        return written;
    }

    public ByteBuffer getContent(int offset, int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.getContent(buf, offset);
        buf.flip();
        return buf;
    }

    public void setStoredMessage(StoredMessage<MessageMetaData> storedMessageHandle) {
        this._storedMessageHandle = storedMessageHandle;
    }

    public StoredMessage<MessageMetaData> getStoredMessage() {
        return this._storedMessageHandle;
    }

    public Object getConnectionReference() {
        return this._connectionReference;
    }

    public MessageMetaData getMessageMetaData() {
        return this._messageMetaData;
    }
}

