/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.SubscriptionFactory;
import org.apache.qpid.server.protocol.v0_8.SubscriptionImpl;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;

public class SubscriptionFactoryImpl
implements SubscriptionFactory {
    public static final SubscriptionFactoryImpl INSTANCE = new SubscriptionFactoryImpl();

    public Subscription createSubscription(int channelId, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager) throws AMQException {
        AMQChannel channel = protocolSession.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "channel :" + channelId + " not found in protocol session");
        }
        ClientDeliveryMethod clientMethod = channel.getClientDeliveryMethod();
        RecordDeliveryMethod recordMethod = channel.getRecordDeliveryMethod();
        return this.createSubscription(channel, protocolSession, consumerTag, acks, filters, noLocal, creditManager, clientMethod, recordMethod);
    }

    public Subscription createSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod clientMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        Boolean isBrowserObj;
        boolean isBrowser = filters != null ? (isBrowserObj = (Boolean)filters.get(AMQPFilterTypes.NO_CONSUME.getValue())) != null && isBrowserObj != false : false;
        if (isBrowser) {
            return new SubscriptionImpl.BrowserSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        if (acks) {
            return new SubscriptionImpl.AckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        return new SubscriptionImpl.NoAckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
    }

    public SubscriptionImpl.GetNoAckSubscription createBasicGetNoAckSubscription(AMQChannel channel, AMQProtocolSession session, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        return new SubscriptionImpl.GetNoAckSubscription(channel, session, null, null, false, creditManager, deliveryMethod, recordMethod);
    }
}

