/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AccessRequestBody;
import org.apache.qpid.framing.AccessRequestOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9;
import org.apache.qpid.framing.amqp_8_0.MethodRegistry_8_0;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessRequestHandler
implements StateAwareMethodListener<AccessRequestBody> {
    private static final AccessRequestHandler _instance = new AccessRequestHandler();

    public static AccessRequestHandler getInstance() {
        return _instance;
    }

    private AccessRequestHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, AccessRequestBody body, int channelId) throws AMQException {
        AccessRequestOkBody response;
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        if (methodRegistry instanceof MethodRegistry_0_9) {
            response = ((MethodRegistry_0_9)methodRegistry).createAccessRequestOkBody(0);
        } else if (methodRegistry instanceof MethodRegistry_8_0) {
            response = ((MethodRegistry_8_0)methodRegistry).createAccessRequestOkBody(0);
        } else {
            throw new AMQException(AMQConstant.COMMAND_INVALID, "AccessRequest not present in AMQP versions other than 0-8, 0-9");
        }
        channel.sync();
        session.writeFrame((AMQDataBlock)response.generateFrame(channelId));
    }
}

