/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelCloseHandler
implements StateAwareMethodListener<ChannelCloseBody> {
    private static final Logger _logger = Logger.getLogger(ChannelCloseHandler.class);
    private static ChannelCloseHandler _instance = new ChannelCloseHandler();

    public static ChannelCloseHandler getInstance() {
        return _instance;
    }

    private ChannelCloseHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ChannelCloseBody body, int channelId) throws AMQException {
        AMQChannel channel;
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Received channel close for id " + channelId + " citing class " + body.getClassId() + " and method " + body.getMethodId()));
        }
        if ((channel = session.getChannel(channelId)) == null) {
            throw body.getConnectionException(AMQConstant.CHANNEL_ERROR, "Trying to close unknown channel");
        }
        channel.sync();
        session.closeChannel(channelId);
        stateManager.getProtocolSession().closeChannelOk(channelId);
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ChannelCloseOkBody responseBody = methodRegistry.createChannelCloseOkBody();
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

