/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeBoundHandler
implements StateAwareMethodListener<ExchangeBoundBody> {
    private static final ExchangeBoundHandler _instance = new ExchangeBoundHandler();
    public static final int OK = 0;
    public static final int EXCHANGE_NOT_FOUND = 1;
    public static final int QUEUE_NOT_FOUND = 2;
    public static final int NO_BINDINGS = 3;
    public static final int QUEUE_NOT_BOUND = 4;
    public static final int NO_QUEUE_BOUND_WITH_RK = 5;
    public static final int SPECIFIC_QUEUE_NOT_BOUND_WITH_RK = 6;

    public static ExchangeBoundHandler getInstance() {
        return _instance;
    }

    private ExchangeBoundHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeBoundBody body, int channelId) throws AMQException {
        ExchangeBoundOkBody response;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        MethodRegistry methodRegistry = session.getMethodRegistry();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        AMQShortString exchangeName = body.getExchange();
        AMQShortString queueName = body.getQueue();
        AMQShortString routingKey = body.getRoutingKey();
        if (exchangeName == null) {
            throw new AMQException("Exchange exchange must not be null");
        }
        Exchange exchange = virtualHost.getExchange(exchangeName.toString());
        if (exchange == null) {
            response = methodRegistry.createExchangeBoundOkBody(1, new AMQShortString("Exchange " + exchangeName + " not found"));
        } else if (routingKey == null) {
            AMQQueue queue;
            response = queueName == null ? (exchange.hasBindings() ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(3, null)) : ((queue = queueRegistry.getQueue(queueName)) == null ? methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found")) : (exchange.isBound(queue) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(4, new AMQShortString("Queue " + queueName + " not bound to exchange " + exchangeName))));
        } else if (queueName != null) {
            AMQQueue queue = queueRegistry.getQueue(queueName);
            if (queue == null) {
                response = methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found"));
            } else if (exchange.isBound(body.getRoutingKey(), queue)) {
                response = methodRegistry.createExchangeBoundOkBody(0, null);
            } else {
                String message = "Queue " + queueName + " not bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName;
                if (message.length() > 255) {
                    message = message.substring(0, 254);
                }
                response = methodRegistry.createExchangeBoundOkBody(6, new AMQShortString(message));
            }
        } else {
            response = exchange.isBound(body.getRoutingKey()) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(5, new AMQShortString("No queue bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName));
        }
        session.writeFrame((AMQDataBlock)response.generateFrame(channelId));
    }
}

