/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDeclareHandler
implements StateAwareMethodListener<ExchangeDeclareBody> {
    private static final Logger _logger = Logger.getLogger(ExchangeDeclareHandler.class);
    private static final ExchangeDeclareHandler _instance = new ExchangeDeclareHandler();

    public static ExchangeDeclareHandler getInstance() {
        return _instance;
    }

    private ExchangeDeclareHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeclareBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        AMQShortString exchangeName = body.getExchange();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Request to declare exchange of type " + body.getType() + " with name " + exchangeName));
        }
        if (body.getPassive()) {
            Exchange exchange = virtualHost.getExchange(exchangeName == null ? null : exchangeName.toString());
            if (exchange == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange: " + exchangeName);
            }
            if (!exchange.getTypeShortString().equals(body.getType()) && body.getType() != null && body.getType().length() != 0) {
                throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getTypeShortString() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
            }
        } else {
            try {
                Exchange exchange = virtualHost.createExchange(null, exchangeName == null ? null : exchangeName.intern().toString(), body.getType() == null ? null : body.getType().intern().toString(), body.getDurable(), body.getAutoDelete(), null);
            }
            catch (ReservedExchangeNameException e) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix.");
            }
            catch (ExchangeExistsException e) {
                Exchange exchange = e.getExistingExchange();
                if (!exchange.getTypeShortString().equals(body.getType())) {
                    throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getTypeShortString() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
                }
            }
            catch (AMQUnknownExchangeType e) {
                throw body.getConnectionException(AMQConstant.COMMAND_INVALID, "Unknown exchange: " + exchangeName, (Throwable)e);
            }
        }
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            ExchangeDeclareOkBody responseBody = methodRegistry.createExchangeDeclareOkBody();
            channel.sync();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

