/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ExchangeDeleteBody;
import org.apache.qpid.framing.ExchangeDeleteOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeInUseException;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.ExchangeIsAlternateException;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDeleteHandler
implements StateAwareMethodListener<ExchangeDeleteBody> {
    private static final ExchangeDeleteHandler _instance = new ExchangeDeleteHandler();

    public static ExchangeDeleteHandler getInstance() {
        return _instance;
    }

    private ExchangeDeleteHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeleteBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        try {
            String exchangeName = body.getExchange() == null ? null : body.getExchange().toString();
            Exchange exchange = virtualHost.getExchange(exchangeName);
            if (exchange == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No such exchange: " + body.getExchange());
            }
            virtualHost.removeExchange(exchange, !body.getIfUnused());
            ExchangeDeleteOkBody responseBody = session.getMethodRegistry().createExchangeDeleteOkBody();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
        catch (ExchangeInUseException e) {
            throw body.getChannelException(AMQConstant.IN_USE, "Exchange in use");
        }
        catch (ExchangeIsAlternateException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Exchange in use as an alternate exchange");
        }
        catch (RequiredExchangeException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Exchange '" + body.getExchange() + "' cannot be deleted");
        }
    }
}

