/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueBindHandler
implements StateAwareMethodListener<QueueBindBody> {
    private static final Logger _log = Logger.getLogger(QueueBindHandler.class);
    private static final QueueBindHandler _instance = new QueueBindHandler();

    public static QueueBindHandler getInstance() {
        return _instance;
    }

    private QueueBindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueBindBody body, int channelId) throws AMQException {
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (body.getQueue() == null) {
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? queue.getNameShortString() : body.getRoutingKey().intern();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
            AMQShortString aMQShortString = routingKey = body.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : body.getRoutingKey().intern();
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        String exchangeName = body.getExchange() == null ? null : body.getExchange().toString();
        Exchange exch = virtualHost.getExchange(exchangeName);
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + exchangeName + " does not exist.");
        }
        try {
            Binding oldBinding;
            Map oldArgs;
            Map arguments;
            String bindingKey;
            AMQSessionModel session;
            if (queue.isExclusive() && !queue.isDurable() && ((session = queue.getExclusiveOwningSession()) == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            }
            if (!exch.isBound(routingKey, body.getArguments(), queue) && !exch.addBinding(bindingKey = String.valueOf(routingKey), queue, arguments = FieldTable.convertToMap((FieldTable)body.getArguments())) && ExchangeDefaults.TOPIC_EXCHANGE_CLASS.equals(exch.getTypeShortString()) && ((oldArgs = (oldBinding = exch.getBinding(bindingKey, queue, arguments)).getArguments()) == null && !arguments.isEmpty() || oldArgs != null && !((Object)oldArgs).equals(arguments))) {
                exch.replaceBinding(oldBinding.getId(), bindingKey, queue, arguments);
            }
        }
        catch (AMQException e) {
            throw body.getChannelException(AMQConstant.CHANNEL_ERROR, e.toString());
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        if (!body.getNowait()) {
            channel.sync();
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueBindOkBody responseBody = methodRegistry.createQueueBindOkBody();
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

