/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuePurgeHandler
implements StateAwareMethodListener<QueuePurgeBody> {
    private static final QueuePurgeHandler _instance = new QueuePurgeHandler();
    private final boolean _failIfNotFound;

    public static QueuePurgeHandler getInstance() {
        return _instance;
    }

    public QueuePurgeHandler() {
        this(true);
    }

    public QueuePurgeHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueuePurgeBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (body.getQueue() == null) {
            queue = channel.getDefaultQueue();
            if (queue == null && this._failIfNotFound) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue specified.");
            }
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            AMQSessionModel session = queue.getExclusiveOwningSession();
            if (queue.isExclusive() && (session == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue is exclusive, but not created on this Connection.");
            }
            long purged = queue.clearQueue();
            if (!body.getNowait()) {
                channel.sync();
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                QueuePurgeOkBody responseBody = methodRegistry.createQueuePurgeOkBody(purged);
                protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            }
        }
    }
}

