/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.QueueUnbindOkBody;
import org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9;
import org.apache.qpid.framing.amqp_0_91.MethodRegistry_0_91;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueUnbindHandler
implements StateAwareMethodListener<QueueUnbindBody> {
    private static final Logger _log = Logger.getLogger(QueueUnbindHandler.class);
    private static final QueueUnbindHandler _instance = new QueueUnbindHandler();

    public static QueueUnbindHandler getInstance() {
        return _instance;
    }

    private QueueUnbindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueUnbindBody body, int channelId) throws AMQException {
        QueueUnbindOkBody responseBody;
        MethodRegistry registry;
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (body.getQueue() == null) {
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? null : body.getRoutingKey().intern();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
            AMQShortString aMQShortString = routingKey = body.getRoutingKey() == null ? null : body.getRoutingKey().intern();
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        Exchange exch = virtualHost.getExchange(body.getExchange() == null ? null : body.getExchange().toString());
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + body.getExchange() + " does not exist.");
        }
        if (exch.getBinding(String.valueOf(routingKey), queue, FieldTable.convertToMap((FieldTable)body.getArguments())) == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "No such binding");
        }
        exch.removeBinding(String.valueOf(routingKey), queue, FieldTable.convertToMap((FieldTable)body.getArguments()));
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        if ((registry = session.getMethodRegistry()) instanceof MethodRegistry_0_9) {
            responseBody = ((MethodRegistry_0_9)registry).createQueueUnbindOkBody();
        } else if (registry instanceof MethodRegistry_0_91) {
            responseBody = ((MethodRegistry_0_91)registry).createQueueUnbindOkBody();
        } else {
            throw new AMQException(AMQConstant.COMMAND_INVALID, "QueueUnbind not present in AMQP version: " + session.getProtocolVersion(), null);
        }
        channel.sync();
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

