/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.TxRollbackBody;
import org.apache.qpid.framing.TxRollbackOkBody;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxRollbackHandler
implements StateAwareMethodListener<TxRollbackBody> {
    private static TxRollbackHandler _instance = new TxRollbackHandler();

    public static TxRollbackHandler getInstance() {
        return _instance;
    }

    private TxRollbackHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxRollbackBody body, int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        try {
            AMQChannel channel = session.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            MethodRegistry methodRegistry = session.getMethodRegistry();
            TxRollbackOkBody responseBody = methodRegistry.createTxRollbackOkBody();
            Runnable task = new Runnable((AMQMethodBody)responseBody, channelId){
                final /* synthetic */ AMQMethodBody val$responseBody;
                final /* synthetic */ int val$channelId;
                {
                    this.val$responseBody = aMQMethodBody;
                    this.val$channelId = n;
                }

                public void run() {
                    session.writeFrame((AMQDataBlock)this.val$responseBody.generateFrame(this.val$channelId));
                }
            };
            channel.rollback(task);
            channel.resend(false);
        }
        catch (AMQException e) {
            throw body.getChannelException(e.getErrorCode(), "Failed to rollback: " + e.getMessage());
        }
    }
}

