/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.output;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.output.ProtocolOutputConverter;
import org.apache.qpid.server.queue.QueueEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final int BASIC_CLASS_ID = 60;
    private final MethodRegistry _methodRegistry;
    private final AMQProtocolSession _protocolSession;

    ProtocolOutputConverterImpl(AMQProtocolSession session, MethodRegistry methodRegistry) {
        this._protocolSession = session;
        this._methodRegistry = methodRegistry;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    @Override
    public void writeDeliver(QueueEntry entry, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        AMQMessage msg = this.convertToAMQMessage(entry);
        AMQBody deliverBody = this.createEncodedDeliverBody(msg, entry.isRedelivered(), deliveryTag, consumerTag);
        this.writeMessageDelivery(msg, channelId, deliverBody);
    }

    private AMQMessage convertToAMQMessage(QueueEntry entry) {
        ServerMessage serverMessage = entry.getMessage();
        if (serverMessage instanceof AMQMessage) {
            return (AMQMessage)serverMessage;
        }
        return (AMQMessage)this.getMessageConverter(serverMessage).convert(serverMessage, entry.getQueue().getVirtualHost());
    }

    private <M extends ServerMessage> MessageConverter<M, AMQMessage> getMessageConverter(M message) {
        Class<?> clazz = message.getClass();
        return MessageConverterRegistry.getConverter(clazz, AMQMessage.class);
    }

    private void writeMessageDelivery(AMQMessage message, int channelId, AMQBody deliverBody) throws AMQException {
        this.writeMessageDelivery((MessageContentSource)message, message.getContentHeaderBody(), channelId, deliverBody);
    }

    private void writeMessageDelivery(MessageContentSource message, ContentHeaderBody contentHeaderBody, int channelId, AMQBody deliverBody) throws AMQException {
        int bodySize = (int)message.getSize();
        if (bodySize == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            int capacity;
            MessageContentSourceBody firstContentBody = new MessageContentSourceBody(message, 0, capacity);
            CompositeAMQBodyBlock compositeBlock = new CompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody, firstContentBody);
            this.writeFrame(compositeBlock);
            for (int writtenSize = capacity = bodySize > (maxBodySize = (int)this.getProtocolSession().getMaxFrameSize() - AMQFrame.getFrameOverhead()) ? maxBodySize : bodySize; writtenSize < bodySize; writtenSize += capacity) {
                int maxBodySize;
                capacity = bodySize - writtenSize > maxBodySize ? maxBodySize : bodySize - writtenSize;
                MessageContentSourceBody body = new MessageContentSourceBody(message, writtenSize, capacity);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, (AMQBody)body));
            }
        }
    }

    @Override
    public void writeGetOk(QueueEntry entry, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQBody deliver = this.createEncodedGetOkBody(entry, deliveryTag, queueSize);
        this.writeMessageDelivery(this.convertToAMQMessage(entry), channelId, deliver);
    }

    private AMQBody createEncodedDeliverBody(AMQMessage message, boolean isRedelivered, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        EncodedDeliveryBody returnBlock = new EncodedDeliveryBody(deliveryTag, routingKey, exchangeName, consumerTag, isRedelivered);
        return returnBlock;
    }

    private AMQBody createEncodedGetOkBody(QueueEntry entry, long deliveryTag, int queueSize) throws AMQException {
        AMQMessage message = this.convertToAMQMessage(entry);
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        boolean isRedelivered = entry.isRedelivered();
        BasicGetOkBody getOkBody = this._methodRegistry.createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, (long)queueSize);
        return getOkBody;
    }

    @Override
    public byte getProtocolMinorVersion() {
        return this._protocolSession.getProtocolMinorVersion();
    }

    @Override
    public byte getProtocolMajorVersion() {
        return this.getProtocolSession().getProtocolMajorVersion();
    }

    private AMQBody createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int replyCode, AMQShortString replyText) throws AMQException {
        BasicReturnBody basicReturnBody = this._methodRegistry.createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
        return basicReturnBody;
    }

    @Override
    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        AMQBody returnFrame = this.createEncodedReturnFrame(messagePublishInfo, replyCode, replyText);
        this.writeMessageDelivery(message, header, channelId, returnFrame);
    }

    @Override
    public void writeFrame(AMQDataBlock block) {
        this.getProtocolSession().writeFrame(block);
    }

    @Override
    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = this._methodRegistry.createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            AMQFrame.writeFrames((DataOutput)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getSimpleName()).append("methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize() + this._contentBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            AMQFrame.writeFrames((DataOutput)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody, (AMQBody)this._contentBody);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(((Object)((Object)this)).getClass().getSimpleName()).append(" methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", contentBody=").append(this._contentBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    private class EncodedDeliveryBody
    implements AMQBody {
        private final long _deliveryTag;
        private final AMQShortString _routingKey;
        private final AMQShortString _exchangeName;
        private final AMQShortString _consumerTag;
        private final boolean _isRedelivered;
        private AMQBody _underlyingBody;

        private EncodedDeliveryBody(long deliveryTag, AMQShortString routingKey, AMQShortString exchangeName, AMQShortString consumerTag, boolean isRedelivered) {
            this._deliveryTag = deliveryTag;
            this._routingKey = routingKey;
            this._exchangeName = exchangeName;
            this._consumerTag = consumerTag;
            this._isRedelivered = isRedelivered;
        }

        public AMQBody createAMQBody() {
            return ProtocolOutputConverterImpl.this._methodRegistry.createBasicDeliverBody(this._consumerTag, this._deliveryTag, this._isRedelivered, this._exchangeName, this._routingKey);
        }

        public byte getFrameType() {
            return 1;
        }

        public int getSize() {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            this._underlyingBody.writePayload(buffer);
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqMinaProtocolSession) throws AMQException {
            throw new AMQException("This block should never be dispatched!");
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " underlyingBody: " + String.valueOf(this._underlyingBody) + "]";
        }
    }

    private class MessageContentSourceBody
    implements AMQBody {
        public static final byte TYPE = 3;
        private int _length;
        private MessageContentSource _message;
        private int _offset;

        public MessageContentSourceBody(MessageContentSource message, int offset, int length) {
            this._message = message;
            this._offset = offset;
            this._length = length;
        }

        public byte getFrameType() {
            return 3;
        }

        public int getSize() {
            return this._length;
        }

        public void writePayload(DataOutput buffer) throws IOException {
            ByteBuffer buf = this._message.getContent(this._offset, this._length);
            if (buf.hasArray()) {
                buffer.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            } else {
                byte[] data = new byte[this._length];
                buf.get(data);
                buffer.write(data);
            }
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws AMQException {
            throw new UnsupportedOperationException();
        }
    }
}

